rule win_lockbit_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lockbit."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lockbit"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 66ad 90 6683f841 720b 6683f85a 7705 }
            // n = 6, score = 300
            //   66ad                 | lodsw               ax, word ptr [esi]
            //   90                   | nop                 
            //   6683f841             | cmp                 ax, 0x41
            //   720b                 | jb                  0xd
            //   6683f85a             | cmp                 ax, 0x5a
            //   7705                 | ja                  7

        $sequence_1 = { 7407 3d9bb4840b 7518 8b4e0c 03cb }
            // n = 5, score = 300
            //   7407                 | je                  9
            //   3d9bb4840b           | cmp                 eax, 0xb84b49b
            //   7518                 | jne                 0x1a
            //   8b4e0c               | mov                 ecx, dword ptr [esi + 0xc]
            //   03cb                 | add                 ecx, ebx

        $sequence_2 = { 6a00 6a00 6800000040 ff75d4 }
            // n = 4, score = 300
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6800000040           | push                0x40000000
            //   ff75d4               | push                dword ptr [ebp - 0x2c]

        $sequence_3 = { 8bec 81ec7c030000 53 56 57 8d9d84fcffff }
            // n = 6, score = 300
            //   8bec                 | mov                 ebp, esp
            //   81ec7c030000         | sub                 esp, 0x37c
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8d9d84fcffff         | lea                 ebx, [ebp - 0x37c]

        $sequence_4 = { 66b82000 f266af 85c9 7512 }
            // n = 4, score = 300
            //   66b82000             | mov                 ax, 0x20
            //   f266af               | repne scasw         ax, word ptr es:[edi]
            //   85c9                 | test                ecx, ecx
            //   7512                 | jne                 0x14

        $sequence_5 = { 8d8550fdffff 50 6a00 ff15???????? }
            // n = 4, score = 300
            //   8d8550fdffff         | lea                 eax, [ebp - 0x2b0]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   ff15????????         |                     

        $sequence_6 = { 33c0 8d7df0 33c9 53 }
            // n = 4, score = 300
            //   33c0                 | xor                 eax, eax
            //   8d7df0               | lea                 edi, [ebp - 0x10]
            //   33c9                 | xor                 ecx, ecx
            //   53                   | push                ebx

        $sequence_7 = { 660f73f904 660fefc8 0f28c1 660f73f804 }
            // n = 4, score = 300
            //   660f73f904           | pslldq              xmm1, 4
            //   660fefc8             | pxor                xmm1, xmm0
            //   0f28c1               | movaps              xmm0, xmm1
            //   660f73f804           | pslldq              xmm0, 4

        $sequence_8 = { 50 8d45fc 50 ff75fc ff75f4 }
            // n = 5, score = 300
            //   50                   | push                eax
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff75f4               | push                dword ptr [ebp - 0xc]

        $sequence_9 = { 33d0 8bc1 c1e810 0fb6c0 c1e208 }
            // n = 5, score = 300
            //   33d0                 | xor                 edx, eax
            //   8bc1                 | mov                 eax, ecx
            //   c1e810               | shr                 eax, 0x10
            //   0fb6c0               | movzx               eax, al
            //   c1e208               | shl                 edx, 8

        $sequence_10 = { 5b 8907 897704 894f08 89570c f745f800000002 740c }
            // n = 7, score = 300
            //   5b                   | pop                 ebx
            //   8907                 | mov                 dword ptr [edi], eax
            //   897704               | mov                 dword ptr [edi + 4], esi
            //   894f08               | mov                 dword ptr [edi + 8], ecx
            //   89570c               | mov                 dword ptr [edi + 0xc], edx
            //   f745f800000002       | test                dword ptr [ebp - 8], 0x2000000
            //   740c                 | je                  0xe

        $sequence_11 = { 47 4e 85f6 75d2 5d 5f 5e }
            // n = 7, score = 300
            //   47                   | inc                 edi
            //   4e                   | dec                 esi
            //   85f6                 | test                esi, esi
            //   75d2                 | jne                 0xffffffd4
            //   5d                   | pop                 ebp
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_12 = { 03d0 90 85c0 75e1 8bc2 5e 5a }
            // n = 7, score = 300
            //   03d0                 | add                 edx, eax
            //   90                   | nop                 
            //   85c0                 | test                eax, eax
            //   75e1                 | jne                 0xffffffe3
            //   8bc2                 | mov                 eax, edx
            //   5e                   | pop                 esi
            //   5a                   | pop                 edx

        $sequence_13 = { 89570c f745f800000002 740c 5f 5e b801000000 }
            // n = 6, score = 300
            //   89570c               | mov                 dword ptr [edi + 0xc], edx
            //   f745f800000002       | test                dword ptr [ebp - 8], 0x2000000
            //   740c                 | je                  0xe
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   b801000000           | mov                 eax, 1

        $sequence_14 = { 57 8d9d84fcffff b900c2eb0b e2fe e8???????? 53 }
            // n = 6, score = 300
            //   57                   | push                edi
            //   8d9d84fcffff         | lea                 ebx, [ebp - 0x37c]
            //   b900c2eb0b           | mov                 ecx, 0xbebc200
            //   e2fe                 | loop                0
            //   e8????????           |                     
            //   53                   | push                ebx

        $sequence_15 = { ff759c 8d858cfeffff 50 ff7610 51 e8???????? 83c628 }
            // n = 7, score = 300
            //   ff759c               | push                dword ptr [ebp - 0x64]
            //   8d858cfeffff         | lea                 eax, [ebp - 0x174]
            //   50                   | push                eax
            //   ff7610               | push                dword ptr [esi + 0x10]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c628               | add                 esi, 0x28

        $sequence_16 = { 8d45f4 50 6a00 6a00 ff15???????? }
            // n = 5, score = 300
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff15????????         |                     

        $sequence_17 = { 8bfb 895830 33fe 897834 8bf7 }
            // n = 5, score = 200
            //   8bfb                 | mov                 edi, ebx
            //   895830               | mov                 dword ptr [eax + 0x30], ebx
            //   33fe                 | xor                 edi, esi
            //   897834               | mov                 dword ptr [eax + 0x34], edi
            //   8bf7                 | mov                 esi, edi

        $sequence_18 = { 894f64 33d6 8b7510 895768 8bda }
            // n = 5, score = 200
            //   894f64               | mov                 dword ptr [edi + 0x64], ecx
            //   33d6                 | xor                 edx, esi
            //   8b7510               | mov                 esi, dword ptr [ebp + 0x10]
            //   895768               | mov                 dword ptr [edi + 0x68], edx
            //   8bda                 | mov                 ebx, edx

        $sequence_19 = { 740b 83e904 8b040e 89040f }
            // n = 4, score = 200
            //   740b                 | je                  0xd
            //   83e904               | sub                 ecx, 4
            //   8b040e               | mov                 eax, dword ptr [esi + ecx]
            //   89040f               | mov                 dword ptr [edi + ecx], eax

        $sequence_20 = { 740b 83e902 0fb7040e 6689040f f6c204 7409 83e904 }
            // n = 7, score = 200
            //   740b                 | je                  0xd
            //   83e902               | sub                 ecx, 2
            //   0fb7040e             | movzx               eax, word ptr [esi + ecx]
            //   6689040f             | mov                 word ptr [edi + ecx], ax
            //   f6c204               | test                dl, 4
            //   7409                 | je                  0xb
            //   83e904               | sub                 ecx, 4

    condition:
        7 of them and filesize < 2049024
}