rule win_logpos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.logpos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.logpos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 55 89e5 60 31c0 31c9 fc 8b7508 }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   60                   | pushal              
            //   31c0                 | xor                 eax, eax
            //   31c9                 | xor                 ecx, ecx
            //   fc                   | cld                 
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]

        $sequence_1 = { e8???????? 894328 681c429282 ff33 ff736c }
            // n = 5, score = 100
            //   e8????????           |                     
            //   894328               | mov                 dword ptr [ebx + 0x28], eax
            //   681c429282           | push                0x8292421c
            //   ff33                 | push                dword ptr [ebx]
            //   ff736c               | push                dword ptr [ebx + 0x6c]

        $sequence_2 = { 83fa00 0f852c000000 8d4001 8945f8 8a00 }
            // n = 5, score = 100
            //   83fa00               | cmp                 edx, 0
            //   0f852c000000         | jne                 0x32
            //   8d4001               | lea                 eax, [eax + 1]
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8a00                 | mov                 al, byte ptr [eax]

        $sequence_3 = { 48 83ec38 53 56 57 41 52 }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   83ec38               | sub                 esp, 0x38
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   41                   | inc                 ecx
            //   52                   | push                edx

        $sequence_4 = { 8b90d8000000 48 85d2 7410 48 394a08 7505 }
            // n = 7, score = 100
            //   8b90d8000000         | mov                 edx, dword ptr [eax + 0xd8]
            //   48                   | dec                 eax
            //   85d2                 | test                edx, edx
            //   7410                 | je                  0x12
            //   48                   | dec                 eax
            //   394a08               | cmp                 dword ptr [edx + 8], ecx
            //   7505                 | jne                 7

        $sequence_5 = { c744241001000000 c744240c00000000 8b442450 89442414 }
            // n = 4, score = 100
            //   c744241001000000     | mov                 dword ptr [esp + 0x10], 1
            //   c744240c00000000     | mov                 dword ptr [esp + 0xc], 0
            //   8b442450             | mov                 eax, dword ptr [esp + 0x50]
            //   89442414             | mov                 dword ptr [esp + 0x14], eax

        $sequence_6 = { 8344242401 48 8344243001 837c243800 7406 48 }
            // n = 6, score = 100
            //   8344242401           | add                 dword ptr [esp + 0x24], 1
            //   48                   | dec                 eax
            //   8344243001           | add                 dword ptr [esp + 0x30], 1
            //   837c243800           | cmp                 dword ptr [esp + 0x38], 0
            //   7406                 | je                  8
            //   48                   | dec                 eax

        $sequence_7 = { 4c 8d0570040000 49 8b88d8000000 48 }
            // n = 5, score = 100
            //   4c                   | dec                 esp
            //   8d0570040000         | lea                 eax, [0x470]
            //   49                   | dec                 ecx
            //   8b88d8000000         | mov                 ecx, dword ptr [eax + 0xd8]
            //   48                   | dec                 eax

        $sequence_8 = { 83f82f 0f8549000000 8b45fc c680a360400000 8b45fc }
            // n = 5, score = 100
            //   83f82f               | cmp                 eax, 0x2f
            //   0f8549000000         | jne                 0x4f
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   c680a360400000       | mov                 byte ptr [eax + 0x4060a3], 0
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_9 = { 68ba917bf6 ff33 ff7370 53 e8???????? 89433c }
            // n = 6, score = 100
            //   68ba917bf6           | push                0xf67b91ba
            //   ff33                 | push                dword ptr [ebx]
            //   ff7370               | push                dword ptr [ebx + 0x70]
            //   53                   | push                ebx
            //   e8????????           |                     
            //   89433c               | mov                 dword ptr [ebx + 0x3c], eax

    condition:
        7 of them and filesize < 57344
}