rule win_logtu_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.logtu."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.logtu"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a64 6a00 ff15???????? 85c0 7509 8b45bc }
            // n = 6, score = 300
            //   6a64                 | push                0x64
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7509                 | jne                 0xb
            //   8b45bc               | mov                 eax, dword ptr [ebp - 0x44]

        $sequence_1 = { ff15???????? 85c0 7509 8b45bc }
            // n = 4, score = 300
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7509                 | jne                 0xb
            //   8b45bc               | mov                 eax, dword ptr [ebp - 0x44]

        $sequence_2 = { ff15???????? 6a01 8bf0 8d85a4fdffff 68???????? 50 }
            // n = 6, score = 300
            //   ff15????????         |                     
            //   6a01                 | push                1
            //   8bf0                 | mov                 esi, eax
            //   8d85a4fdffff         | lea                 eax, [ebp - 0x25c]
            //   68????????           |                     
            //   50                   | push                eax

        $sequence_3 = { 81ec98050000 a1???????? 33c5 8945fc 53 56 57 }
            // n = 7, score = 300
            //   81ec98050000         | sub                 esp, 0x598
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi

        $sequence_4 = { 6800080000 50 8d85fcf7ffff 50 e8???????? }
            // n = 5, score = 300
            //   6800080000           | push                0x800
            //   50                   | push                eax
            //   8d85fcf7ffff         | lea                 eax, [ebp - 0x804]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_5 = { 50 8d85fcf7ffff 68???????? 50 e8???????? 8d85fcf7ffff }
            // n = 6, score = 300
            //   50                   | push                eax
            //   8d85fcf7ffff         | lea                 eax, [ebp - 0x804]
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d85fcf7ffff         | lea                 eax, [ebp - 0x804]

        $sequence_6 = { 8d8578faffff 50 8d8584faffff 50 }
            // n = 4, score = 300
            //   8d8578faffff         | lea                 eax, [ebp - 0x588]
            //   50                   | push                eax
            //   8d8584faffff         | lea                 eax, [ebp - 0x57c]
            //   50                   | push                eax

        $sequence_7 = { 8d8578faffff 50 8d8584faffff 50 8d8574faffff }
            // n = 5, score = 300
            //   8d8578faffff         | lea                 eax, [ebp - 0x588]
            //   50                   | push                eax
            //   8d8584faffff         | lea                 eax, [ebp - 0x57c]
            //   50                   | push                eax
            //   8d8574faffff         | lea                 eax, [ebp - 0x58c]

        $sequence_8 = { 6a01 8bf0 8d85a4fdffff 68???????? 50 ff15???????? 83c40c }
            // n = 7, score = 300
            //   6a01                 | push                1
            //   8bf0                 | mov                 esi, eax
            //   8d85a4fdffff         | lea                 eax, [ebp - 0x25c]
            //   68????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_9 = { 68???????? 50 e8???????? 8d85fcf7ffff 6800040000 50 }
            // n = 6, score = 300
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d85fcf7ffff         | lea                 eax, [ebp - 0x804]
            //   6800040000           | push                0x400
            //   50                   | push                eax

    condition:
        7 of them and filesize < 924672
}