rule win_lolsnif_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lolsnif."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lolsnif"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7313 57 57 57 57 53 ff75fc }
            // n = 7, score = 200
            //   7313                 | jae                 0x15
            //   57                   | push                edi
            //   57                   | push                edi
            //   57                   | push                edi
            //   57                   | push                edi
            //   53                   | push                ebx
            //   ff75fc               | push                dword ptr [ebp - 4]

        $sequence_1 = { 5b c20c00 55 8bec 83ec14 817d0c00100000 }
            // n = 6, score = 200
            //   5b                   | pop                 ebx
            //   c20c00               | ret                 0xc
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec14               | sub                 esp, 0x14
            //   817d0c00100000       | cmp                 dword ptr [ebp + 0xc], 0x1000

        $sequence_2 = { b892e8ffff c3 55 8bec 83ec40 53 56 }
            // n = 7, score = 200
            //   b892e8ffff           | mov                 eax, 0xffffe892
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec40               | sub                 esp, 0x40
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_3 = { e8???????? 8bf0 3bf3 7439 3bfb 7411 8b4718 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   3bf3                 | cmp                 esi, ebx
            //   7439                 | je                  0x3b
            //   3bfb                 | cmp                 edi, ebx
            //   7411                 | je                  0x13
            //   8b4718               | mov                 eax, dword ptr [edi + 0x18]

        $sequence_4 = { 33db 53 c744241001000000 bf???????? ffd6 ff7508 57 }
            // n = 7, score = 200
            //   33db                 | xor                 ebx, ebx
            //   53                   | push                ebx
            //   c744241001000000     | mov                 dword ptr [esp + 0x10], 1
            //   bf????????           |                     
            //   ffd6                 | call                esi
            //   ff7508               | push                dword ptr [ebp + 8]
            //   57                   | push                edi

        $sequence_5 = { f00fc108 a1???????? 83c040 50 ffd3 a1???????? 56 }
            // n = 7, score = 200
            //   f00fc108             | lock xadd           dword ptr [eax], ecx
            //   a1????????           |                     
            //   83c040               | add                 eax, 0x40
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   a1????????           |                     
            //   56                   | push                esi

        $sequence_6 = { eb06 41 894804 33ff 5b 8bc7 5f }
            // n = 7, score = 200
            //   eb06                 | jmp                 8
            //   41                   | inc                 ecx
            //   894804               | mov                 dword ptr [eax + 4], ecx
            //   33ff                 | xor                 edi, edi
            //   5b                   | pop                 ebx
            //   8bc7                 | mov                 eax, edi
            //   5f                   | pop                 edi

        $sequence_7 = { 3bc6 8945f4 754d 8b4dc0 56 ff35???????? 8bc1 }
            // n = 7, score = 200
            //   3bc6                 | cmp                 eax, esi
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   754d                 | jne                 0x4f
            //   8b4dc0               | mov                 ecx, dword ptr [ebp - 0x40]
            //   56                   | push                esi
            //   ff35????????         |                     
            //   8bc1                 | mov                 eax, ecx

        $sequence_8 = { ab ab 8d442428 50 8d44241c 50 }
            // n = 6, score = 200
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   8d442428             | lea                 eax, [esp + 0x28]
            //   50                   | push                eax
            //   8d44241c             | lea                 eax, [esp + 0x1c]
            //   50                   | push                eax

        $sequence_9 = { ff7704 e8???????? 3de8000000 7509 834dfcff e9???????? }
            // n = 6, score = 200
            //   ff7704               | push                dword ptr [edi + 4]
            //   e8????????           |                     
            //   3de8000000           | cmp                 eax, 0xe8
            //   7509                 | jne                 0xb
            //   834dfcff             | or                  dword ptr [ebp - 4], 0xffffffff
            //   e9????????           |                     

    condition:
        7 of them and filesize < 425984
}