rule win_lorenz_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lorenz."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lorenz"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bec 51 894dfc 6a0c 8b4508 50 8b4dfc }
            // n = 7, score = 300
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   6a0c                 | push                0xc
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_1 = { 894db0 8b55b0 3b55f4 7314 8b45b0 8b4dfc 8b1481 }
            // n = 7, score = 300
            //   894db0               | mov                 dword ptr [ebp - 0x50], ecx
            //   8b55b0               | mov                 edx, dword ptr [ebp - 0x50]
            //   3b55f4               | cmp                 edx, dword ptr [ebp - 0xc]
            //   7314                 | jae                 0x16
            //   8b45b0               | mov                 eax, dword ptr [ebp - 0x50]
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b1481               | mov                 edx, dword ptr [ecx + eax*4]

        $sequence_2 = { e8???????? 8945f8 8b55fc 833a02 753d 8b4df8 e8???????? }
            // n = 7, score = 300
            //   e8????????           |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   833a02               | cmp                 dword ptr [edx], 2
            //   753d                 | jne                 0x3f
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   e8????????           |                     

        $sequence_3 = { e8???????? 68???????? 8d4d84 51 e8???????? 8b5514 52 }
            // n = 7, score = 300
            //   e8????????           |                     
            //   68????????           |                     
            //   8d4d84               | lea                 ecx, [ebp - 0x7c]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8b5514               | mov                 edx, dword ptr [ebp + 0x14]
            //   52                   | push                edx

        $sequence_4 = { 8b4dfc e8???????? 0fb6d0 85d2 7454 8b45fc 8b480c }
            // n = 7, score = 300
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   0fb6d0               | movzx               edx, al
            //   85d2                 | test                edx, edx
            //   7454                 | je                  0x56
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b480c               | mov                 ecx, dword ptr [eax + 0xc]

        $sequence_5 = { ff15???????? 33d2 8b450c 66895004 8b4d0c 8b55f4 8911 }
            // n = 7, score = 300
            //   ff15????????         |                     
            //   33d2                 | xor                 edx, edx
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   66895004             | mov                 word ptr [eax + 4], dx
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   8911                 | mov                 dword ptr [ecx], edx

        $sequence_6 = { 8b55dc 8b02 50 8b4d08 51 8b4ddc e8???????? }
            // n = 7, score = 300
            //   8b55dc               | mov                 edx, dword ptr [ebp - 0x24]
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   50                   | push                eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   51                   | push                ecx
            //   8b4ddc               | mov                 ecx, dword ptr [ebp - 0x24]
            //   e8????????           |                     

        $sequence_7 = { 83c410 e9???????? 68???????? 8d4dbc e8???????? 8b4dec 8b11 }
            // n = 7, score = 300
            //   83c410               | add                 esp, 0x10
            //   e9????????           |                     
            //   68????????           |                     
            //   8d4dbc               | lea                 ecx, [ebp - 0x44]
            //   e8????????           |                     
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   8b11                 | mov                 edx, dword ptr [ecx]

        $sequence_8 = { 6a00 68840a0000 68???????? 6a02 e8???????? 83c418 83f801 }
            // n = 7, score = 300
            //   6a00                 | push                0
            //   68840a0000           | push                0xa84
            //   68????????           |                     
            //   6a02                 | push                2
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   83f801               | cmp                 eax, 1

        $sequence_9 = { cc 33d2 75c3 33c0 75bf 837dfc00 7408 }
            // n = 7, score = 300
            //   cc                   | int3                
            //   33d2                 | xor                 edx, edx
            //   75c3                 | jne                 0xffffffc5
            //   33c0                 | xor                 eax, eax
            //   75bf                 | jne                 0xffffffc1
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   7408                 | je                  0xa

    condition:
        7 of them and filesize < 2254848
}