rule win_loup_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.loup."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.loup"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4508 50 8d8de0fbffff 51 8d95f0fdffff 52 }
            // n = 6, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax
            //   8d8de0fbffff         | lea                 ecx, [ebp - 0x420]
            //   51                   | push                ecx
            //   8d95f0fdffff         | lea                 edx, [ebp - 0x210]
            //   52                   | push                edx

        $sequence_1 = { 668945e8 33c0 668945ea c745ee01000000 b804000000 }
            // n = 5, score = 100
            //   668945e8             | mov                 word ptr [ebp - 0x18], ax
            //   33c0                 | xor                 eax, eax
            //   668945ea             | mov                 word ptr [ebp - 0x16], ax
            //   c745ee01000000       | mov                 dword ptr [ebp - 0x12], 1
            //   b804000000           | mov                 eax, 4

        $sequence_2 = { 8d15341a4100 e8???????? 58 5a 5f 5e }
            // n = 6, score = 100
            //   8d15341a4100         | lea                 edx, [0x411a34]
            //   e8????????           |                     
            //   58                   | pop                 eax
            //   5a                   | pop                 edx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_3 = { 33c5 8945fc b9???????? e8???????? c745c000000000 c745b400000000 }
            // n = 6, score = 100
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   b9????????           |                     
            //   e8????????           |                     
            //   c745c000000000       | mov                 dword ptr [ebp - 0x40], 0
            //   c745b400000000       | mov                 dword ptr [ebp - 0x4c], 0

        $sequence_4 = { c784055cffffff01000000 8d855cffffff 8945d5 8bf4 6a03 }
            // n = 5, score = 100
            //   c784055cffffff01000000     | mov    dword ptr [ebp + eax - 0xa4], 1
            //   8d855cffffff         | lea                 eax, [ebp - 0xa4]
            //   8945d5               | mov                 dword ptr [ebp - 0x2b], eax
            //   8bf4                 | mov                 esi, esp
            //   6a03                 | push                3

        $sequence_5 = { 7709 8b048514824100 5d c3 33c0 }
            // n = 5, score = 100
            //   7709                 | ja                  0xb
            //   8b048514824100       | mov                 eax, dword ptr [eax*4 + 0x418214]
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   33c0                 | xor                 eax, eax

        $sequence_6 = { c705????????01000000 b904000000 6bd100 c78264a1410002000000 b804000000 6bc800 }
            // n = 6, score = 100
            //   c705????????01000000     |     
            //   b904000000           | mov                 ecx, 4
            //   6bd100               | imul                edx, ecx, 0
            //   c78264a1410002000000     | mov    dword ptr [edx + 0x41a164], 2
            //   b804000000           | mov                 eax, 4
            //   6bc800               | imul                ecx, eax, 0

        $sequence_7 = { a1???????? 8985c4fbffff 8b0d???????? 898dc8fbffff 8b15???????? }
            // n = 5, score = 100
            //   a1????????           |                     
            //   8985c4fbffff         | mov                 dword ptr [ebp - 0x43c], eax
            //   8b0d????????         |                     
            //   898dc8fbffff         | mov                 dword ptr [ebp - 0x438], ecx
            //   8b15????????         |                     

        $sequence_8 = { 668945e8 33c0 668945ea c745ee01000000 }
            // n = 4, score = 100
            //   668945e8             | mov                 word ptr [ebp - 0x18], ax
            //   33c0                 | xor                 eax, eax
            //   668945ea             | mov                 word ptr [ebp - 0x16], ax
            //   c745ee01000000       | mov                 dword ptr [ebp - 0x12], 1

        $sequence_9 = { 51 e8???????? 85c0 7513 8b45f4 50 e8???????? }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7513                 | jne                 0x15
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   50                   | push                eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 257024
}