rule win_lowkey_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lowkey."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lowkey"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c8bf2 488d8d70010000 33d2 41b800020000 e8???????? }
            // n = 5, score = 100
            //   4c8bf2               | je                  0x1713
            //   488d8d70010000       | dec                 eax
            //   33d2                 | test                eax, eax
            //   41b800020000         | dec                 eax
            //   e8????????           |                     

        $sequence_1 = { 83bb7004000002 0f848d010000 83cfff 488d2db7310100 83635000 83632c00 e9???????? }
            // n = 7, score = 100
            //   83bb7004000002       | dec                 ecx
            //   0f848d010000         | mov                 ebx, dword ptr [ebx + 0x28]
            //   83cfff               | dec                 ecx
            //   488d2db7310100       | mov                 esi, dword ptr [ebx + 0x30]
            //   83635000             | dec                 ecx
            //   83632c00             | mov                 edi, dword ptr [ebx + 0x38]
            //   e9????????           |                     

        $sequence_2 = { 498bc2 458bf1 48c1f806 488d0df41e0300 4183e23f 4d03f0 }
            // n = 6, score = 100
            //   498bc2               | mov                 dword ptr [esp + 0x28], esi
            //   458bf1               | inc                 ebp
            //   48c1f806             | xor                 eax, eax
            //   488d0df41e0300       | xor                 edx, edx
            //   4183e23f             | mov                 dword ptr [esp + 0x30], esi
            //   4d03f0               | dec                 eax

        $sequence_3 = { 3b15???????? 7350 488bca 4c8d05c9230300 83e13f 488bc2 }
            // n = 6, score = 100
            //   3b15????????         |                     
            //   7350                 | mov                 eax, 0x68
            //   488bca               | or                  eax, 0xffffffff
            //   4c8d05c9230300       | dec                 eax
            //   83e13f               | mov                 ecx, dword ptr [esp + 0x38]
            //   488bc2               | dec                 eax

        $sequence_4 = { 48898424d0000000 4533c0 488b4708 488bd5 48898424e0000000 }
            // n = 5, score = 100
            //   48898424d0000000     | dec                 eax
            //   4533c0               | lea                 ebp, [esp - 0x2090]
            //   488b4708             | mov                 eax, 0x2190
            //   488bd5               | inc                 ecx
            //   48898424e0000000     | push                ebp

        $sequence_5 = { 488b0d???????? 488b5210 488b8900040000 ff15???????? 488b15???????? 4533c0 }
            // n = 6, score = 100
            //   488b0d????????       |                     
            //   488b5210             | mov                 word ptr [ebp - 0x40], dx
            //   488b8900040000       | dec                 ebx
            //   ff15????????         |                     
            //   488b15????????       |                     
            //   4533c0               | mov                 edx, dword ptr [esi + edi*8]

        $sequence_6 = { 85c0 0f94c3 8bc3 488b4c2478 }
            // n = 4, score = 100
            //   85c0                 | dec                 eax
            //   0f94c3               | mov                 ebx, eax
            //   8bc3                 | dec                 eax
            //   488b4c2478           | lea                 edx, [0x2f7d0]

        $sequence_7 = { 33d2 488bc8 ff15???????? 488d1556260200 }
            // n = 4, score = 100
            //   33d2                 | je                  0x310
            //   488bc8               | dec                 ecx
            //   ff15????????         |                     
            //   488d1556260200       | dec                 eax

        $sequence_8 = { 488bcf e8???????? 488d4df7 e8???????? 488d155cfd0100 488d4df7 e8???????? }
            // n = 7, score = 100
            //   488bcf               | mov                 ecx, 0x1388
            //   e8????????           |                     
            //   488d4df7             | dec                 eax
            //   e8????????           |                     
            //   488d155cfd0100       | lea                 edx, [0x224b0]
            //   488d4df7             | dec                 eax
            //   e8????????           |                     

        $sequence_9 = { 488d15c10d0200 4533c0 48895c2420 488b01 ff5020 488b4c2450 4c8d4de8 }
            // n = 7, score = 100
            //   488d15c10d0200       | je                  0x61e
            //   4533c0               | movzx               eax, word ptr [esp + 0x65]
            //   48895c2420           | cmp                 ax, si
            //   488b01               | jne                 0x4c7
            //   ff5020               | dec                 eax
            //   488b4c2450           | lea                 edx, [esp + 0x170]
            //   4c8d4de8             | test                eax, eax

    condition:
        7 of them and filesize < 643072
}