rule win_lpeclient_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lpeclient."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lpeclient"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d5c3e04 b8fcffffff 2bc7 8b7c2430 03f8 81ff00100000 }
            // n = 6, score = 100
            //   488d5c3e04           | mov                 dword ptr [ebp + 0xa6], 0x38
            //   b8fcffffff           | mov                 dword ptr [ebp - 0x68], 1
            //   2bc7                 | xor                 eax, eax
            //   8b7c2430             | dec                 esp
            //   03f8                 | lea                 eax, [0x19c78]
            //   81ff00100000         | mov                 dword ptr [ebp + 0xa4], 0x730072

        $sequence_1 = { 488d05ddf80000 483947f0 7412 488b0f 4885c9 740a }
            // n = 6, score = 100
            //   488d05ddf80000       | inc                 ecx
            //   483947f0             | lea                 ecx, [edx + eax]
            //   7412                 | mov                 eax, dword ptr [ebp + 0x54]
            //   488b0f               | inc                 ebx
            //   4885c9               | xor                 edx, dword ptr [esp + eax*4 + 0x1a360]
            //   740a                 | rol                 edx, 0xb

        $sequence_2 = { c7450c74006900 c745106f006e00 c745143a002000 c745184b006500 c7451e70002d00 c7452241006c00 }
            // n = 6, score = 100
            //   c7450c74006900       | mov                 ecx, edx
            //   c745106f006e00       | dec                 eax
            //   c745143a002000       | arpl                cx, cx
            //   c745184b006500       | dec                 eax
            //   c7451e70002d00       | lea                 edx, [0x113fc]
            //   c7452241006c00       | dec                 eax

        $sequence_3 = { 488d0518f90000 483bc8 741a 83b96001000000 7511 e8???????? 488b8b58010000 }
            // n = 7, score = 100
            //   488d0518f90000       | inc                 ecx
            //   483bc8               | mov                 eax, 0x206
            //   741a                 | mov                 dword ptr [esp + 0x44], esi
            //   83b96001000000       | mov                 dword ptr [esp + 0x20], edi
            //   7511                 | inc                 ebp
            //   e8????????           |                     
            //   488b8b58010000       | xor                 eax, eax

        $sequence_4 = { 4c8d0da1fd0000 33c0 498bd1 448d4008 3b0a 742b ffc0 }
            // n = 7, score = 100
            //   4c8d0da1fd0000       | movzx               eax, byte ptr [edx + 0x1d]
            //   33c0                 | or                  ecx, eax
            //   498bd1               | movzx               eax, byte ptr [edx + 0x1e]
            //   448d4008             | shl                 ecx, 8
            //   3b0a                 | or                  ecx, eax
            //   742b                 | movzx               eax, byte ptr [edx + 0x1f]
            //   ffc0                 | mov                 edx, 8

        $sequence_5 = { 48c1e814 488d0dbfd2ffff 83e00f 339481a0a40100 }
            // n = 4, score = 100
            //   48c1e814             | dec                 eax
            //   488d0dbfd2ffff       | mov                 dword ptr [esp + 0x50], eax
            //   83e00f               | mov                 dword ptr [esp + 0x34], 0x40c
            //   339481a0a40100       | inc                 esp

        $sequence_6 = { 488bcf ff15???????? 488b8c2400030000 4833cc e8???????? 488b9c2420030000 }
            // n = 6, score = 100
            //   488bcf               | inc                 ecx
            //   ff15????????         |                     
            //   488b8c2400030000     | mov                 dword ptr [esp], ebx
            //   4833cc               | movzx               eax, byte ptr [ebp + edx + 0x30]
            //   e8????????           |                     
            //   488b9c2420030000     | dec                 eax

        $sequence_7 = { 7508 42807c120122 7427 41ffc0 48ffc2 443bc1 }
            // n = 6, score = 100
            //   7508                 | xor                 edx, dword ptr [esp + eax*4 + 0x1a520]
            //   42807c120122         | mov                 eax, dword ptr [ebp + 0x5c]
            //   7427                 | inc                 ebx
            //   41ffc0               | xor                 edx, dword ptr [esp + eax*4 + 0x1a360]
            //   48ffc2               | rol                 edx, 0xb
            //   443bc1               | inc                 esp

        $sequence_8 = { 33d2 48f7d1 83e903 85c9 7e1c 6690 42803c123a }
            // n = 7, score = 100
            //   33d2                 | dec                 eax
            //   48f7d1               | lea                 ecx, [ebp - 9]
            //   83e903               | mov                 dword ptr [ebp - 9], 0x40
            //   85c9                 | dec                 eax
            //   7e1c                 | lea                 ecx, [edi + 0x50]
            //   6690                 | mov                 dword ptr [edi + 0x2e4], 1
            //   42803c123a           | dec                 eax

        $sequence_9 = { 0f84b8010000 488d2d15e70000 41bc14030000 4c8d0528800000 488bcd 418bd4 e8???????? }
            // n = 7, score = 100
            //   0f84b8010000         | mov                 eax, ecx
            //   488d2d15e70000       | dec                 eax
            //   41bc14030000         | shr                 ecx, 0x18
            //   4c8d0528800000       | and                 ecx, 0xf
            //   488bcd               | inc                 ecx
            //   418bd4               | mov                 eax, eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 289792
}