rule win_lumma_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lumma."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lumma"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 53 ff767c ff7678 ff7644 }
            // n = 4, score = 1100
            //   53                   | push                ebx
            //   ff767c               | push                dword ptr [esi + 0x7c]
            //   ff7678               | push                dword ptr [esi + 0x78]
            //   ff7644               | push                dword ptr [esi + 0x44]

        $sequence_1 = { ffd0 83c40c 894648 85c0 }
            // n = 4, score = 1000
            //   ffd0                 | call                eax
            //   83c40c               | add                 esp, 0xc
            //   894648               | mov                 dword ptr [esi + 0x48], eax
            //   85c0                 | test                eax, eax

        $sequence_2 = { 894604 8b461c c1e002 50 }
            // n = 4, score = 1000
            //   894604               | mov                 dword ptr [esi + 4], eax
            //   8b461c               | mov                 eax, dword ptr [esi + 0x1c]
            //   c1e002               | shl                 eax, 2
            //   50                   | push                eax

        $sequence_3 = { ff7678 ff7644 ff563c 83c414 }
            // n = 4, score = 1000
            //   ff7678               | push                dword ptr [esi + 0x78]
            //   ff7644               | push                dword ptr [esi + 0x44]
            //   ff563c               | call                dword ptr [esi + 0x3c]
            //   83c414               | add                 esp, 0x14

        $sequence_4 = { 833800 740a e8???????? 833822 }
            // n = 4, score = 1000
            //   833800               | cmp                 dword ptr [eax], 0
            //   740a                 | je                  0xc
            //   e8????????           |                     
            //   833822               | cmp                 dword ptr [eax], 0x22

        $sequence_5 = { 66894316 0fb7560e 0fb74e0c e8???????? }
            // n = 4, score = 900
            //   66894316             | mov                 word ptr [ebx + 0x16], ax
            //   0fb7560e             | movzx               edx, word ptr [esi + 0xe]
            //   0fb74e0c             | movzx               ecx, word ptr [esi + 0xc]
            //   e8????????           |                     

        $sequence_6 = { 66894338 8b4626 89433c 8b462a }
            // n = 4, score = 900
            //   66894338             | mov                 word ptr [ebx + 0x38], ax
            //   8b4626               | mov                 eax, dword ptr [esi + 0x26]
            //   89433c               | mov                 dword ptr [ebx + 0x3c], eax
            //   8b462a               | mov                 eax, dword ptr [esi + 0x2a]

        $sequence_7 = { 8b4610 894320 8b4614 894328 }
            // n = 4, score = 900
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]
            //   894320               | mov                 dword ptr [ebx + 0x20], eax
            //   8b4614               | mov                 eax, dword ptr [esi + 0x14]
            //   894328               | mov                 dword ptr [ebx + 0x28], eax

        $sequence_8 = { e8???????? 83c40c 6a02 6804010000 e8???????? }
            // n = 5, score = 800
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   6a02                 | push                2
            //   6804010000           | push                0x104
            //   e8????????           |                     

        $sequence_9 = { 017e78 83567c00 017e68 83566c00 }
            // n = 4, score = 800
            //   017e78               | add                 dword ptr [esi + 0x78], edi
            //   83567c00             | adc                 dword ptr [esi + 0x7c], 0
            //   017e68               | add                 dword ptr [esi + 0x68], edi
            //   83566c00             | adc                 dword ptr [esi + 0x6c], 0

        $sequence_10 = { 83f900 75f1 83ec04 8b4508 e8???????? 89ec 5d }
            // n = 7, score = 700
            //   83f900               | cmp                 ecx, 0
            //   75f1                 | jne                 0xfffffff3
            //   83ec04               | sub                 esp, 4
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   e8????????           |                     
            //   89ec                 | mov                 esp, ebp
            //   5d                   | pop                 ebp

        $sequence_11 = { 31c0 837e3808 0f94c0 294628 }
            // n = 4, score = 700
            //   31c0                 | xor                 eax, eax
            //   837e3808             | cmp                 dword ptr [esi + 0x38], 8
            //   0f94c0               | sete                al
            //   294628               | sub                 dword ptr [esi + 0x28], eax

        $sequence_12 = { 0f94c3 89d5 09cd 0f95c7 }
            // n = 4, score = 700
            //   0f94c3               | sete                bl
            //   89d5                 | mov                 ebp, edx
            //   09cd                 | or                  ebp, ecx
            //   0f95c7               | setne               bh

        $sequence_13 = { 0f95c7 30df 7514 837e6c00 }
            // n = 4, score = 700
            //   0f95c7               | setne               bh
            //   30df                 | xor                 bh, bl
            //   7514                 | jne                 0x16
            //   837e6c00             | cmp                 dword ptr [esi + 0x6c], 0

        $sequence_14 = { 8b5204 45 8b4208 45 8b4a0c 49 83fe04 }
            // n = 7, score = 700
            //   8b5204               | mov                 edx, dword ptr [edx + 4]
            //   45                   | inc                 ebp
            //   8b4208               | mov                 eax, dword ptr [edx + 8]
            //   45                   | inc                 ebp
            //   8b4a0c               | mov                 ecx, dword ptr [edx + 0xc]
            //   49                   | dec                 ecx
            //   83fe04               | cmp                 esi, 4

        $sequence_15 = { 01e8 56 ff742424 50 }
            // n = 4, score = 700
            //   01e8                 | add                 eax, ebp
            //   56                   | push                esi
            //   ff742424             | push                dword ptr [esp + 0x24]
            //   50                   | push                eax

        $sequence_16 = { 50 57 ff7618 e8???????? 83c40c 894618 }
            // n = 6, score = 700
            //   50                   | push                eax
            //   57                   | push                edi
            //   ff7618               | push                dword ptr [esi + 0x18]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   894618               | mov                 dword ptr [esi + 0x18], eax

        $sequence_17 = { 01c9 39dd ba00000000 19c2 72f1 }
            // n = 5, score = 700
            //   01c9                 | add                 ecx, ecx
            //   39dd                 | cmp                 ebp, ebx
            //   ba00000000           | mov                 edx, 0
            //   19c2                 | sbb                 edx, eax
            //   72f1                 | jb                  0xfffffff3

        $sequence_18 = { 234608 7418 8b8684000000 29f8 }
            // n = 4, score = 700
            //   234608               | and                 eax, dword ptr [esi + 8]
            //   7418                 | je                  0x1a
            //   8b8684000000         | mov                 eax, dword ptr [esi + 0x84]
            //   29f8                 | sub                 eax, edi

        $sequence_19 = { 31ed 89ae88000000 c7868c00000000000000 899e80000000 833e00 }
            // n = 5, score = 700
            //   31ed                 | xor                 ebp, ebp
            //   89ae88000000         | mov                 dword ptr [esi + 0x88], ebp
            //   c7868c00000000000000     | mov    dword ptr [esi + 0x8c], 0
            //   899e80000000         | mov                 dword ptr [esi + 0x80], ebx
            //   833e00               | cmp                 dword ptr [esi], 0

        $sequence_20 = { 8b550c 6bd204 89d1 83e904 8b5510 8b1c0a }
            // n = 6, score = 700
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   6bd204               | imul                edx, edx, 4
            //   89d1                 | mov                 ecx, edx
            //   83e904               | sub                 ecx, 4
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   8b1c0a               | mov                 ebx, dword ptr [edx + ecx]

    condition:
        7 of them and filesize < 1115136
}