rule win_lurk_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.lurk."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lurk"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff7508 ff15???????? 8b35???????? 50 ff7508 }
            // n = 5, score = 1100
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     
            //   8b35????????         |                     
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_1 = { 8b4508 5b 5f 5e c9 c3 55 }
            // n = 7, score = 900
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   5b                   | pop                 ebx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   c9                   | leave               
            //   c3                   | ret                 
            //   55                   | push                ebp

        $sequence_2 = { 8908 8b4514 85c0 7407 8b4e28 03cf }
            // n = 6, score = 800
            //   8908                 | mov                 dword ptr [eax], ecx
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   8b4e28               | mov                 ecx, dword ptr [esi + 0x28]
            //   03cf                 | add                 ecx, edi

        $sequence_3 = { 0f84e0000000 8b45fc 8b4dd8 03480c 51 ff55f4 }
            // n = 6, score = 800
            //   0f84e0000000         | je                  0xe6
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b4dd8               | mov                 ecx, dword ptr [ebp - 0x28]
            //   03480c               | add                 ecx, dword ptr [eax + 0xc]
            //   51                   | push                ecx
            //   ff55f4               | call                dword ptr [ebp - 0xc]

        $sequence_4 = { 8955f4 837df404 7325 8b4df0 }
            // n = 4, score = 800
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx
            //   837df404             | cmp                 dword ptr [ebp - 0xc], 4
            //   7325                 | jae                 0x27
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]

        $sequence_5 = { 80780500 8d45fc 7404 6a00 eb02 6a01 50 }
            // n = 7, score = 800
            //   80780500             | cmp                 byte ptr [eax + 5], 0
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   7404                 | je                  6
            //   6a00                 | push                0
            //   eb02                 | jmp                 4
            //   6a01                 | push                1
            //   50                   | push                eax

        $sequence_6 = { 5f 5e c9 c20400 a1???????? 32c9 384802 }
            // n = 7, score = 800
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   c9                   | leave               
            //   c20400               | ret                 4
            //   a1????????           |                     
            //   32c9                 | xor                 cl, cl
            //   384802               | cmp                 byte ptr [eax + 2], cl

        $sequence_7 = { eb29 837d0803 7504 6a03 eb08 837d0804 7519 }
            // n = 7, score = 800
            //   eb29                 | jmp                 0x2b
            //   837d0803             | cmp                 dword ptr [ebp + 8], 3
            //   7504                 | jne                 6
            //   6a03                 | push                3
            //   eb08                 | jmp                 0xa
            //   837d0804             | cmp                 dword ptr [ebp + 8], 4
            //   7519                 | jne                 0x1b

        $sequence_8 = { c9 c3 6afe eb02 6afd }
            // n = 5, score = 800
            //   c9                   | leave               
            //   c3                   | ret                 
            //   6afe                 | push                -2
            //   eb02                 | jmp                 4
            //   6afd                 | push                -3

        $sequence_9 = { 8945cc 8b45fc 83c008 8945f0 }
            // n = 4, score = 800
            //   8945cc               | mov                 dword ptr [ebp - 0x34], eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   83c008               | add                 eax, 8
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax

        $sequence_10 = { 8945fc e8???????? c745f801000000 2975f8 }
            // n = 4, score = 800
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   e8????????           |                     
            //   c745f801000000       | mov                 dword ptr [ebp - 8], 1
            //   2975f8               | sub                 dword ptr [ebp - 8], esi

        $sequence_11 = { a1???????? 385805 744f 53 53 }
            // n = 5, score = 800
            //   a1????????           |                     
            //   385805               | cmp                 byte ptr [eax + 5], bl
            //   744f                 | je                  0x51
            //   53                   | push                ebx
            //   53                   | push                ebx

        $sequence_12 = { 8945d0 8b45f8 895dd4 8945d8 8b3d???????? }
            // n = 5, score = 800
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   895dd4               | mov                 dword ptr [ebp - 0x2c], ebx
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   8b3d????????         |                     

        $sequence_13 = { 8955f0 8b45f4 8b4814 c1e11f c1f91f 7412 }
            // n = 6, score = 800
            //   8955f0               | mov                 dword ptr [ebp - 0x10], edx
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8b4814               | mov                 ecx, dword ptr [eax + 0x14]
            //   c1e11f               | shl                 ecx, 0x1f
            //   c1f91f               | sar                 ecx, 0x1f
            //   7412                 | je                  0x14

        $sequence_14 = { 8955f0 e9???????? 8b55fc 8b45ec }
            // n = 4, score = 800
            //   8955f0               | mov                 dword ptr [ebp - 0x10], edx
            //   e9????????           |                     
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]

        $sequence_15 = { 8945d4 837dd400 7513 8b45d8 }
            // n = 4, score = 800
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   837dd400             | cmp                 dword ptr [ebp - 0x2c], 0
            //   7513                 | jne                 0x15
            //   8b45d8               | mov                 eax, dword ptr [ebp - 0x28]

    condition:
        7 of them and filesize < 5316608
}