rule win_magic_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.magic_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.magic_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5e 5f 5d c3 660f28c8 f20f5c0d???????? }
            // n = 6, score = 600
            //   5e                   | mov                 dword ptr [esp + 0xd0], esi
            //   5f                   | dec                 esp
            //   5d                   | xor                 edx, esi
            //   c3                   | dec                 esp
            //   660f28c8             | xor                 edx, dword ptr [esp + 0x58]
            //   f20f5c0d????????     |                     

        $sequence_1 = { 89c3 e8???????? 660fefc0 f20f2ac3 }
            // n = 4, score = 600
            //   89c3                 | mov                 dword ptr [edi + 8], eax
            //   e8????????           |                     
            //   660fefc0             | mov                 dword ptr [esp + 0x20], eax
            //   f20f2ac3             | sub                 eax, 1

        $sequence_2 = { 660f28d8 f20f5c1d???????? f20f2cc3 660fefdb }
            // n = 4, score = 600
            //   660f28d8             | sub                 dword ptr [edi + 0x20], eax
            //   f20f5c1d????????     |                     
            //   f20f2cc3             | dec                 ecx
            //   660fefdb             | mov                 eax, esi

        $sequence_3 = { 894664 8b4368 894668 8b436c }
            // n = 4, score = 600
            //   894664               | cmp                 edx, -1
            //   8b4368               | je                  0x3da
            //   894668               | test                edx, edx
            //   8b436c               | je                  0x787

        $sequence_4 = { c1e008 29d0 c1f810 84c0 }
            // n = 4, score = 600
            //   c1e008               | mov                 eax, dword ptr [ecx + 0x18]
            //   29d0                 | cmp                 dword ptr [ecx + 0xc], eax
            //   c1f810               | lea                 eax, [edi + 0x18]
            //   84c0                 | mov                 dword ptr [esp + 0x24], eax

        $sequence_5 = { 8b12 83fa01 740a 83fa02 7405 83fa03 }
            // n = 6, score = 600
            //   8b12                 | mov                 byte ptr [esi], cl
            //   83fa01               | mov                 edx, esi
            //   740a                 | mov                 byte ptr [ecx + 0x30], dl
            //   83fa02               | and                 ebp, 2
            //   7405                 | jne                 0x4e1
            //   83fa03               | movzx               eax, byte ptr [ecx + 0x30]

        $sequence_6 = { 0fb6442425 0fb6542427 c1e018 c1e210 09d0 }
            // n = 5, score = 600
            //   0fb6442425           | mov                 eax, dword ptr [esp + 0x38]
            //   0fb6542427           | je                  0x6cd
            //   c1e018               | cmp                 edi, 2
            //   c1e210               | je                  0x76f
            //   09d0                 | dec                 eax

        $sequence_7 = { 8b02 83c001 83f801 0f8721010000 }
            // n = 4, score = 600
            //   8b02                 | mov                 ecx, ebp
            //   83c001               | dec                 ecx
            //   83f801               | mov                 eax, esi
            //   0f8721010000         | mov                 dword ptr [esp + 0x84], eax

        $sequence_8 = { be02000000 e8???????? 84c0 75d5 }
            // n = 4, score = 600
            //   be02000000           | mov                 dword ptr [esp + 4], 8
            //   e8????????           |                     
            //   84c0                 | mov                 dword ptr [esp + 8], eax
            //   75d5                 | lea                 eax, [esp + 0x60]

        $sequence_9 = { 7410 66c1e802 0fb7c0 69d07b140000 }
            // n = 4, score = 600
            //   7410                 | inc                 ecx
            //   66c1e802             | mov                 dword ptr [esi + edi + 0xa8], eax
            //   0fb7c0               | inc                 ecx
            //   69d07b140000         | mov                 dword ptr [esi + ebx*4 + 0x84], eax

    condition:
        7 of them and filesize < 41843712
}