rule win_manitsme_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.manitsme."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.manitsme"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 895c2450 ffd6 8b35???????? 8d542410 52 }
            // n = 5, score = 100
            //   895c2450             | mov                 dword ptr [esp + 0x50], ebx
            //   ffd6                 | call                esi
            //   8b35????????         |                     
            //   8d542410             | lea                 edx, [esp + 0x10]
            //   52                   | push                edx

        $sequence_1 = { 85c0 0f84a2000000 837c241000 766e 6a00 8d442414 50 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   0f84a2000000         | je                  0xa8
            //   837c241000           | cmp                 dword ptr [esp + 0x10], 0
            //   766e                 | jbe                 0x70
            //   6a00                 | push                0
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   50                   | push                eax

        $sequence_2 = { 8bc8 c1f905 8d1c8d40580110 8bf0 83e61f 6bf628 8b0b }
            // n = 7, score = 100
            //   8bc8                 | mov                 ecx, eax
            //   c1f905               | sar                 ecx, 5
            //   8d1c8d40580110       | lea                 ebx, [ecx*4 + 0x10015840]
            //   8bf0                 | mov                 esi, eax
            //   83e61f               | and                 esi, 0x1f
            //   6bf628               | imul                esi, esi, 0x28
            //   8b0b                 | mov                 ecx, dword ptr [ebx]

        $sequence_3 = { d96c2416 e8???????? 83c404 85c0 7505 b8100e0000 }
            // n = 6, score = 100
            //   d96c2416             | fldcw               word ptr [esp + 0x16]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   7505                 | jne                 7
            //   b8100e0000           | mov                 eax, 0xe10

        $sequence_4 = { 6a02 68???????? be07000000 e8???????? }
            // n = 4, score = 100
            //   6a02                 | push                2
            //   68????????           |                     
            //   be07000000           | mov                 esi, 7
            //   e8????????           |                     

        $sequence_5 = { 68???????? 32db e8???????? dc0d???????? }
            // n = 4, score = 100
            //   68????????           |                     
            //   32db                 | xor                 bl, bl
            //   e8????????           |                     
            //   dc0d????????         |                     

        $sequence_6 = { 52 be04010000 8bfb e8???????? }
            // n = 4, score = 100
            //   52                   | push                edx
            //   be04010000           | mov                 esi, 0x104
            //   8bfb                 | mov                 edi, ebx
            //   e8????????           |                     

        $sequence_7 = { ff15???????? 6a00 b801000000 e8???????? 83c404 b801000000 c20c00 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   b801000000           | mov                 eax, 1
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   b801000000           | mov                 eax, 1
            //   c20c00               | ret                 0xc

        $sequence_8 = { ffd3 85c0 7586 50 ff15???????? }
            // n = 5, score = 100
            //   ffd3                 | call                ebx
            //   85c0                 | test                eax, eax
            //   7586                 | jne                 0xffffff88
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_9 = { 7416 8bc1 83e01f 6bc028 8bd1 c1fa05 03049540580110 }
            // n = 7, score = 100
            //   7416                 | je                  0x18
            //   8bc1                 | mov                 eax, ecx
            //   83e01f               | and                 eax, 0x1f
            //   6bc028               | imul                eax, eax, 0x28
            //   8bd1                 | mov                 edx, ecx
            //   c1fa05               | sar                 edx, 5
            //   03049540580110       | add                 eax, dword ptr [edx*4 + 0x10015840]

    condition:
        7 of them and filesize < 212992
}