rule win_matrix_banker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.matrix_banker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.matrix_banker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 80f905 7705 80c2a9 eb0b 8d4abf 80f905 }
            // n = 6, score = 900
            //   80f905               | mov                 edx, dword ptr [edi + 0x20]
            //   7705                 | inc                 esp
            //   80c2a9               | mov                 dword ptr [edi + 0x2c], eax
            //   eb0b                 | dec                 eax
            //   8d4abf               | mov                 edx, ebx
            //   80f905               | dec                 eax

        $sequence_1 = { 80f905 7704 04a9 eb0a }
            // n = 4, score = 900
            //   80f905               | lea                 ecx, [esp + 0x48]
            //   7704                 | lea                 edx, [ebp + 0x21]
            //   04a9                 | dec                 esp
            //   eb0a                 | mov                 eax, eax

        $sequence_2 = { eb16 8d489f 80f905 7704 }
            // n = 4, score = 900
            //   eb16                 | mov                 esi, eax
            //   8d489f               | mov                 eax, dword ptr [ebp - 8]
            //   80f905               | test                esi, esi
            //   7704                 | cmove               eax, dword ptr [ebp - 0x20]

        $sequence_3 = { 66890d???????? 66030d???????? 66890d???????? e8???????? }
            // n = 4, score = 900
            //   66890d????????       |                     
            //   66030d????????       |                     
            //   66890d????????       |                     
            //   e8????????           |                     

        $sequence_4 = { 8d48bf 80f905 7702 04c9 }
            // n = 4, score = 900
            //   8d48bf               | push                0
            //   80f905               | mov                 eax, dword ptr [ecx]
            //   7702                 | push                0
            //   04c9                 | push                ecx

        $sequence_5 = { 8d4abf 80f905 7703 80c2c9 }
            // n = 4, score = 900
            //   8d4abf               | lea                 edi, [esi + 0xfff]
            //   80f905               | and                 eax, 0xfffff000
            //   7703                 | mov                 eax, dword ptr [ebx]
            //   80c2c9               | push                0

        $sequence_6 = { 8d489f 80f905 7704 04a9 }
            // n = 4, score = 900
            //   8d489f               | mov                 eax, dword ptr [esi + 0x14]
            //   80f905               | mov                 eax, dword ptr [ecx]
            //   7704                 | push                edx
            //   04a9                 | push                1

        $sequence_7 = { eb0a 8d48bf 80f905 7702 04c9 8d4ad0 80f909 }
            // n = 7, score = 900
            //   eb0a                 | mov                 ecx, dword ptr [edi + 0x24]
            //   8d48bf               | jae                 0x1327
            //   80f905               | dec                 eax
            //   7702                 | mov                 eax, dword ptr [eax]
            //   04c9                 | dec                 eax
            //   8d4ad0               | cmp                 eax, edx
            //   80f909               | jne                 0x1316

        $sequence_8 = { 04a9 eb0a 8d48bf 80f905 7702 }
            // n = 5, score = 900
            //   04a9                 | mov                 esi, dword ptr [edi + 0x20]
            //   eb0a                 | mov                 byte ptr [edi + ebx], 0
            //   8d48bf               | jmp                 0x1105
            //   80f905               | mov                 ecx, dword ptr [ebp - 0x14]
            //   7702                 | mov                 byte ptr [eax + esi], 0

        $sequence_9 = { 80f905 7705 80c2a9 eb0b 8d4abf }
            // n = 5, score = 900
            //   80f905               | mov                 ebx, eax
            //   7705                 | inc                 esp
            //   80c2a9               | lea                 eax, [eax + 1]
            //   eb0b                 | dec                 eax
            //   8d4abf               | lea                 ecx, [0x166b1]

    condition:
        7 of them and filesize < 422912
}