rule win_matsnu_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.matsnu."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.matsnu"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 8985bcfbffff 83bdb0fbffff01 0f8588000000 8b85bcfbffff 8985c4fbffff 8b85c0fbffff }
            // n = 7, score = 700
            //   e9????????           |                     
            //   8985bcfbffff         | mov                 dword ptr [ebp - 0x444], eax
            //   83bdb0fbffff01       | cmp                 dword ptr [ebp - 0x450], 1
            //   0f8588000000         | jne                 0x8e
            //   8b85bcfbffff         | mov                 eax, dword ptr [ebp - 0x444]
            //   8985c4fbffff         | mov                 dword ptr [ebp - 0x43c], eax
            //   8b85c0fbffff         | mov                 eax, dword ptr [ebp - 0x440]

        $sequence_1 = { c645f700 c645f800 c645f90d c645fa0a c645fb00 }
            // n = 5, score = 700
            //   c645f700             | mov                 byte ptr [ebp - 9], 0
            //   c645f800             | mov                 byte ptr [ebp - 8], 0
            //   c645f90d             | mov                 byte ptr [ebp - 7], 0xd
            //   c645fa0a             | mov                 byte ptr [ebp - 6], 0xa
            //   c645fb00             | mov                 byte ptr [ebp - 5], 0

        $sequence_2 = { 750f c785a4fbffff02000000 e9???????? 8985bcfbffff 83bdb0fbffff01 }
            // n = 5, score = 700
            //   750f                 | jne                 0x11
            //   c785a4fbffff02000000     | mov    dword ptr [ebp - 0x45c], 2
            //   e9????????           |                     
            //   8985bcfbffff         | mov                 dword ptr [ebp - 0x444], eax
            //   83bdb0fbffff01       | cmp                 dword ptr [ebp - 0x450], 1

        $sequence_3 = { 8b75fa 01c6 8b4604 48 0145de ff45c6 }
            // n = 6, score = 700
            //   8b75fa               | mov                 esi, dword ptr [ebp - 6]
            //   01c6                 | add                 esi, eax
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   48                   | dec                 eax
            //   0145de               | add                 dword ptr [ebp - 0x22], eax
            //   ff45c6               | inc                 dword ptr [ebp - 0x3a]

        $sequence_4 = { 0f8229010000 c745ea00000000 8b45e6 c1e004 8b75fa }
            // n = 5, score = 700
            //   0f8229010000         | jb                  0x12f
            //   c745ea00000000       | mov                 dword ptr [ebp - 0x16], 0
            //   8b45e6               | mov                 eax, dword ptr [ebp - 0x1a]
            //   c1e004               | shl                 eax, 4
            //   8b75fa               | mov                 esi, dword ptr [ebp - 6]

        $sequence_5 = { 751d ff75ba ff7510 e8???????? 8945f6 }
            // n = 5, score = 700
            //   751d                 | jne                 0x1f
            //   ff75ba               | push                dword ptr [ebp - 0x46]
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   e8????????           |                     
            //   8945f6               | mov                 dword ptr [ebp - 0xa], eax

        $sequence_6 = { 884db8 807db800 7503 ff45be }
            // n = 4, score = 700
            //   884db8               | mov                 byte ptr [ebp - 0x48], cl
            //   807db800             | cmp                 byte ptr [ebp - 0x48], 0
            //   7503                 | jne                 5
            //   ff45be               | inc                 dword ptr [ebp - 0x42]

        $sequence_7 = { c745f600000000 c745fa00000000 e8???????? 5b }
            // n = 4, score = 700
            //   c745f600000000       | mov                 dword ptr [ebp - 0xa], 0
            //   c745fa00000000       | mov                 dword ptr [ebp - 6], 0
            //   e8????????           |                     
            //   5b                   | pop                 ebx

        $sequence_8 = { 837d1800 7405 8b7d18 8907 b820000000 }
            // n = 5, score = 700
            //   837d1800             | cmp                 dword ptr [ebp + 0x18], 0
            //   7405                 | je                  7
            //   8b7d18               | mov                 edi, dword ptr [ebp + 0x18]
            //   8907                 | mov                 dword ptr [edi], eax
            //   b820000000           | mov                 eax, 0x20

        $sequence_9 = { 31c0 8985bcfbffff ffb5c4fbffff e8???????? 83f800 }
            // n = 5, score = 700
            //   31c0                 | xor                 eax, eax
            //   8985bcfbffff         | mov                 dword ptr [ebp - 0x444], eax
            //   ffb5c4fbffff         | push                dword ptr [ebp - 0x43c]
            //   e8????????           |                     
            //   83f800               | cmp                 eax, 0

    condition:
        7 of them and filesize < 606992
}