rule win_maui_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.maui."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.maui"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85ff 7505 49 85c9 7ff2 894e04 5f }
            // n = 7, score = 100
            //   85ff                 | test                edi, edi
            //   7505                 | jne                 7
            //   49                   | dec                 ecx
            //   85c9                 | test                ecx, ecx
            //   7ff2                 | jg                  0xfffffff4
            //   894e04               | mov                 dword ptr [esi + 4], ecx
            //   5f                   | pop                 edi

        $sequence_1 = { 85f6 7479 6a00 e8???????? 8d4c240c 51 89442410 }
            // n = 7, score = 100
            //   85f6                 | test                esi, esi
            //   7479                 | je                  0x7b
            //   6a00                 | push                0
            //   e8????????           |                     
            //   8d4c240c             | lea                 ecx, [esp + 0xc]
            //   51                   | push                ecx
            //   89442410             | mov                 dword ptr [esp + 0x10], eax

        $sequence_2 = { 241c 51 57 e8???????? 83c418 85c0 }
            // n = 6, score = 100
            //   241c                 | and                 al, 0x1c
            //   51                   | push                ecx
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   85c0                 | test                eax, eax

        $sequence_3 = { 50 53 e8???????? 83c408 85c0 0f84a2000000 83c602 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   53                   | push                ebx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   0f84a2000000         | je                  0xa8
            //   83c602               | add                 esi, 2

        $sequence_4 = { 68d7020000 68???????? 6886000000 68a3000000 6a06 c7450000000000 e8???????? }
            // n = 7, score = 100
            //   68d7020000           | push                0x2d7
            //   68????????           |                     
            //   6886000000           | push                0x86
            //   68a3000000           | push                0xa3
            //   6a06                 | push                6
            //   c7450000000000       | mov                 dword ptr [ebp], 0
            //   e8????????           |                     

        $sequence_5 = { 894c2420 0fb60f bd07010000 897c241c 66852c48 7431 0fb64f01 }
            // n = 7, score = 100
            //   894c2420             | mov                 dword ptr [esp + 0x20], ecx
            //   0fb60f               | movzx               ecx, byte ptr [edi]
            //   bd07010000           | mov                 ebp, 0x107
            //   897c241c             | mov                 dword ptr [esp + 0x1c], edi
            //   66852c48             | test                word ptr [eax + ecx*2], bp
            //   7431                 | je                  0x33
            //   0fb64f01             | movzx               ecx, byte ptr [edi + 1]

        $sequence_6 = { 41 57 51 e8???????? 83c40c 85c0 0f84d9000000 }
            // n = 7, score = 100
            //   41                   | inc                 ecx
            //   57                   | push                edi
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   0f84d9000000         | je                  0xdf

        $sequence_7 = { e8???????? a3???????? e8???????? 85c0 7d09 e8???????? 85c0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   a3????????           |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7d09                 | jge                 0xb
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_8 = { 8b5c2410 55 8b6c241c 57 8b7c241c 81fd00000040 724e }
            // n = 7, score = 100
            //   8b5c2410             | mov                 ebx, dword ptr [esp + 0x10]
            //   55                   | push                ebp
            //   8b6c241c             | mov                 ebp, dword ptr [esp + 0x1c]
            //   57                   | push                edi
            //   8b7c241c             | mov                 edi, dword ptr [esp + 0x1c]
            //   81fd00000040         | cmp                 ebp, 0x40000000
            //   724e                 | jb                  0x50

        $sequence_9 = { 3bca 741f 8b4624 3bc2 7418 894c2418 895620 }
            // n = 7, score = 100
            //   3bca                 | cmp                 ecx, edx
            //   741f                 | je                  0x21
            //   8b4624               | mov                 eax, dword ptr [esi + 0x24]
            //   3bc2                 | cmp                 eax, edx
            //   7418                 | je                  0x1a
            //   894c2418             | mov                 dword ptr [esp + 0x18], ecx
            //   895620               | mov                 dword ptr [esi + 0x20], edx

    condition:
        7 of them and filesize < 1616896
}