rule win_mayberobot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mayberobot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mayberobot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4883ec28 803d????????00 754c 488d0da8270100 }
            // n = 4, score = 100
            //   4883ec28             | mov                 byte ptr [esp + 0x70], dh
            //   803d????????00       |                     
            //   754c                 | jmp                 0xb1
            //   488d0da8270100       | dec                 eax

        $sequence_1 = { 45390a 7449 496312 4803d5 0fb60a 83e10f 4a0fbe843110440100 }
            // n = 7, score = 100
            //   45390a               | mov                 dword ptr [ecx], ebx
            //   7449                 | dec                 eax
            //   496312               | add                 esp, 0x20
            //   4803d5               | dec                 eax
            //   0fb60a               | lea                 ecx, [0x1326b]
            //   83e10f               | dec                 eax
            //   4a0fbe843110440100     | mov    dword ptr [eax], ecx

        $sequence_2 = { 4885c0 7509 488d05233a0100 eb04 }
            // n = 4, score = 100
            //   4885c0               | dec                 eax
            //   7509                 | lea                 ecx, [0x8383]
            //   488d05233a0100       | inc                 ebp
            //   eb04                 | xor                 ecx, ecx

        $sequence_3 = { 90 8bdf 8b05???????? 48895c2420 3bf0 7c36 4c8d3da9080100 }
            // n = 7, score = 100
            //   90                   | dec                 eax
            //   8bdf                 | sar                 eax, 6
            //   8b05????????         |                     
            //   48895c2420           | dec                 eax
            //   3bf0                 | lea                 ebx, [ecx + ecx*8]
            //   7c36                 | inc                 ebp
            //   4c8d3da9080100       | cmp                 dword ptr [edx], ecx

        $sequence_4 = { 4c8d058afb0000 488b4318 4839b838010000 750f 498b04d0 42387ce839 0f84d3000000 }
            // n = 7, score = 100
            //   4c8d058afb0000       | dec                 eax
            //   488b4318             | mov                 ebx, dword ptr [esp + 0x50]
            //   4839b838010000       | dec                 eax
            //   750f                 | mov                 ebp, dword ptr [esp + 0x58]
            //   498b04d0             | xor                 al, al
            //   42387ce839           | dec                 eax
            //   0f84d3000000         | add                 esp, 0x20

        $sequence_5 = { 488d0d8a0b0100 e8???????? 4883c428 c3 }
            // n = 4, score = 100
            //   488d0d8a0b0100       | dec                 eax
            //   e8????????           |                     
            //   4883c428             | lea                 edx, [0xfffefcd7]
            //   c3                   | and                 ecx, 0x3f

        $sequence_6 = { e8???????? 85c0 7420 4c8b442430 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   85c0                 | dec                 eax
            //   7420                 | cmp                 dword ptr [esp + 0x90], 0x10
            //   4c8b442430           | jae                 0x1a9

        $sequence_7 = { 488d151fc50000 b903000000 4c8d050bc50000 e8???????? 488bd3 }
            // n = 5, score = 100
            //   488d151fc50000       | dec                 eax
            //   b903000000           | lea                 eax, [0x10244]
            //   4c8d050bc50000       | dec                 eax
            //   e8????????           |                     
            //   488bd3               | mov                 dword ptr [ebx], eax

        $sequence_8 = { 4183f90f 7779 428b8c8e78f80000 4803ce ffe1 660f73fa01 eb65 }
            // n = 7, score = 100
            //   4183f90f             | dec                 eax
            //   7779                 | lea                 ecx, [ebp - 8]
            //   428b8c8e78f80000     | dec                 eax
            //   4803ce               | mov                 ecx, ebx
            //   ffe1                 | cmp                 dword ptr [ebx + 0x10], 0
            //   660f73fa01           | jne                 0xab4
            //   eb65                 | dec                 eax

        $sequence_9 = { 488bd1 488bc1 48c1f806 4c8d05b4060100 }
            // n = 4, score = 100
            //   488bd1               | lea                 edx, [0x19ed7]
            //   488bc1               | dec                 eax
            //   48c1f806             | cmp                 eax, 0xe
            //   4c8d05b4060100       | ja                  0x51a

    condition:
        7 of them and filesize < 307200
}