rule win_maze_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.maze."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.maze"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 53 57 56 83ec10 8b4510 8b4d0c 8b5508 }
            // n = 7, score = 2400
            //   53                   | push                ebx
            //   57                   | push                edi
            //   56                   | push                esi
            //   83ec10               | sub                 esp, 0x10
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]

        $sequence_1 = { f3aa 61 8945f0 c745f000000000 }
            // n = 4, score = 2400
            //   f3aa                 | rep stosb           byte ptr es:[edi], al
            //   61                   | popal               
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   c745f000000000       | mov                 dword ptr [ebp - 0x10], 0

        $sequence_2 = { 8b4d0c 8b5508 837d0800 8945ec }
            // n = 4, score = 2400
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax

        $sequence_3 = { 7509 c745f000000000 eb17 60 8b7d08 8b4d10 8b450c }
            // n = 7, score = 2400
            //   7509                 | jne                 0xb
            //   c745f000000000       | mov                 dword ptr [ebp - 0x10], 0
            //   eb17                 | jmp                 0x19
            //   60                   | pushal              
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_4 = { 837d0800 8945ec 894de8 8955e4 7509 c745f000000000 eb17 }
            // n = 7, score = 2400
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   894de8               | mov                 dword ptr [ebp - 0x18], ecx
            //   8955e4               | mov                 dword ptr [ebp - 0x1c], edx
            //   7509                 | jne                 0xb
            //   c745f000000000       | mov                 dword ptr [ebp - 0x10], 0
            //   eb17                 | jmp                 0x19

        $sequence_5 = { 8945f0 c745f000000000 8b45f0 83c410 5e 5f 5b }
            // n = 7, score = 2400
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   c745f000000000       | mov                 dword ptr [ebp - 0x10], 0
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   83c410               | add                 esp, 0x10
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi
            //   5b                   | pop                 ebx

        $sequence_6 = { 89c8 ba8390f5ff f7e2 29ca }
            // n = 4, score = 2300
            //   89c8                 | mov                 eax, ecx
            //   ba8390f5ff           | mov                 edx, 0xfff59083
            //   f7e2                 | mul                 edx
            //   29ca                 | sub                 edx, ecx

        $sequence_7 = { 89c8 c0e807 00c8 d0f8 }
            // n = 4, score = 2300
            //   89c8                 | mov                 eax, ecx
            //   c0e807               | shr                 al, 7
            //   00c8                 | add                 al, cl
            //   d0f8                 | sar                 al, 1

        $sequence_8 = { 41 41 41 41 41 41 41 }
            // n = 7, score = 1600
            //   41                   | inc                 ecx
            //   41                   | inc                 ecx
            //   41                   | inc                 ecx
            //   41                   | inc                 ecx
            //   41                   | inc                 ecx
            //   41                   | inc                 ecx
            //   41                   | inc                 ecx

        $sequence_9 = { e9???????? 895dc8 8d4dc8 51 50 }
            // n = 5, score = 1400
            //   e9????????           |                     
            //   895dc8               | mov                 dword ptr [ebp - 0x38], ebx
            //   8d4dc8               | lea                 ecx, [ebp - 0x38]
            //   51                   | push                ecx
            //   50                   | push                eax

        $sequence_10 = { 58 6bc000 c7805cb1410002000000 6a04 58 }
            // n = 5, score = 100
            //   58                   | pop                 eax
            //   6bc000               | imul                eax, eax, 0
            //   c7805cb1410002000000     | mov    dword ptr [eax + 0x41b15c], 2
            //   6a04                 | push                4
            //   58                   | pop                 eax

        $sequence_11 = { 8b94961c080000 89940140100000 8b45fc 8b4d08 8b948124080000 c1e217 8b45fc }
            // n = 7, score = 100
            //   8b94961c080000       | mov                 edx, dword ptr [esi + edx*4 + 0x81c]
            //   89940140100000       | mov                 dword ptr [ecx + eax + 0x1040], edx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b948124080000       | mov                 edx, dword ptr [ecx + eax*4 + 0x824]
            //   c1e217               | shl                 edx, 0x17
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_12 = { 8b4508 8a8c1040100000 888da3fdffff ba04000000 }
            // n = 4, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8a8c1040100000       | mov                 cl, byte ptr [eax + edx + 0x1040]
            //   888da3fdffff         | mov                 byte ptr [ebp - 0x25d], cl
            //   ba04000000           | mov                 edx, 4

        $sequence_13 = { b804000000 6bc803 8b5508 8b840a00100000 c1e016 b904000000 }
            // n = 6, score = 100
            //   b804000000           | mov                 eax, 4
            //   6bc803               | imul                ecx, eax, 3
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b840a00100000       | mov                 eax, dword ptr [edx + ecx + 0x1000]
            //   c1e016               | shl                 eax, 0x16
            //   b904000000           | mov                 ecx, 4

        $sequence_14 = { b804000000 6bc805 8b5508 8a840a40100000 888593feffff b904000000 }
            // n = 6, score = 100
            //   b804000000           | mov                 eax, 4
            //   6bc805               | imul                ecx, eax, 5
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8a840a40100000       | mov                 al, byte ptr [edx + ecx + 0x1040]
            //   888593feffff         | mov                 byte ptr [ebp - 0x16d], al
            //   b904000000           | mov                 ecx, 4

        $sequence_15 = { c1ea08 0bc2 898574ffffff 8b857cffffff }
            // n = 4, score = 100
            //   c1ea08               | shr                 edx, 8
            //   0bc2                 | or                  eax, edx
            //   898574ffffff         | mov                 dword ptr [ebp - 0x8c], eax
            //   8b857cffffff         | mov                 eax, dword ptr [ebp - 0x84]

        $sequence_16 = { 8b4508 8a8c1040100000 888d1bfeffff ba04000000 6bc20b 8b4d08 8b940140100000 }
            // n = 7, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8a8c1040100000       | mov                 cl, byte ptr [eax + edx + 0x1040]
            //   888d1bfeffff         | mov                 byte ptr [ebp - 0x1e5], cl
            //   ba04000000           | mov                 edx, 4
            //   6bc20b               | imul                eax, edx, 0xb
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b940140100000       | mov                 edx, dword ptr [ecx + eax + 0x1040]

        $sequence_17 = { 51 ff559c 3bf4 e8???????? 894598 837d9800 757e }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   ff559c               | call                dword ptr [ebp - 0x64]
            //   3bf4                 | cmp                 esi, esp
            //   e8????????           |                     
            //   894598               | mov                 dword ptr [ebp - 0x68], eax
            //   837d9800             | cmp                 dword ptr [ebp - 0x68], 0
            //   757e                 | jne                 0x80

    condition:
        7 of them and filesize < 2318336
}