rule win_mbrlock_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mbrlock."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mbrlock"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 663d0500 7445 668bce 668bd0 66c1e90a 66c1ea0a }
            // n = 6, score = 100
            //   663d0500             | cmp                 ax, 5
            //   7445                 | je                  0x47
            //   668bce               | mov                 cx, si
            //   668bd0               | mov                 dx, ax
            //   66c1e90a             | shr                 cx, 0xa
            //   66c1ea0a             | shr                 dx, 0xa

        $sequence_1 = { 8965f0 8b4708 8975ec 85c0 c745fc00000000 7422 50 }
            // n = 7, score = 100
            //   8965f0               | mov                 dword ptr [ebp - 0x10], esp
            //   8b4708               | mov                 eax, dword ptr [edi + 8]
            //   8975ec               | mov                 dword ptr [ebp - 0x14], esi
            //   85c0                 | test                eax, eax
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   7422                 | je                  0x24
            //   50                   | push                eax

        $sequence_2 = { e8???????? 8d4d8c c745fcffffffff e8???????? b801000000 8b4df4 64890d00000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d4d8c               | lea                 ecx, [ebp - 0x74]
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   e8????????           |                     
            //   b801000000           | mov                 eax, 1
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx

        $sequence_3 = { 6685d2 740c 33c9 663bf0 0f94c1 }
            // n = 5, score = 100
            //   6685d2               | test                dx, dx
            //   740c                 | je                  0xe
            //   33c9                 | xor                 ecx, ecx
            //   663bf0               | cmp                 si, ax
            //   0f94c1               | sete                cl

        $sequence_4 = { 85f6 7407 8d4608 85c0 7517 8d442410 }
            // n = 6, score = 100
            //   85f6                 | test                esi, esi
            //   7407                 | je                  9
            //   8d4608               | lea                 eax, [esi + 8]
            //   85c0                 | test                eax, eax
            //   7517                 | jne                 0x19
            //   8d442410             | lea                 eax, [esp + 0x10]

        $sequence_5 = { 6a00 52 57 50 ff5624 8bf8 85ff }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   52                   | push                edx
            //   57                   | push                edi
            //   50                   | push                eax
            //   ff5624               | call                dword ptr [esi + 0x24]
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi

        $sequence_6 = { 83c410 8b45ec 8d4e24 50 53 }
            // n = 5, score = 100
            //   83c410               | add                 esp, 0x10
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   8d4e24               | lea                 ecx, [esi + 0x24]
            //   50                   | push                eax
            //   53                   | push                ebx

        $sequence_7 = { c744242044764a00 8d4c2420 6a01 8d542444 51 52 8bce }
            // n = 7, score = 100
            //   c744242044764a00     | mov                 dword ptr [esp + 0x20], 0x4a7644
            //   8d4c2420             | lea                 ecx, [esp + 0x20]
            //   6a01                 | push                1
            //   8d542444             | lea                 edx, [esp + 0x44]
            //   51                   | push                ecx
            //   52                   | push                edx
            //   8bce                 | mov                 ecx, esi

        $sequence_8 = { 5b 0f94c0 81c480010000 c3 5f 5e 33c0 }
            // n = 7, score = 100
            //   5b                   | pop                 ebx
            //   0f94c0               | sete                al
            //   81c480010000         | add                 esp, 0x180
            //   c3                   | ret                 
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   33c0                 | xor                 eax, eax

        $sequence_9 = { 7409 53 e8???????? 83c404 68010100a0 6a00 }
            // n = 6, score = 100
            //   7409                 | je                  0xb
            //   53                   | push                ebx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   68010100a0           | push                0xa0000101
            //   6a00                 | push                0

    condition:
        7 of them and filesize < 2031616
}