rule win_mechanical_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mechanical."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mechanical"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 03c7 3bca 72ed 5f }
            // n = 4, score = 200
            //   03c7                 | add                 eax, edi
            //   3bca                 | cmp                 ecx, edx
            //   72ed                 | jb                  0xffffffef
            //   5f                   | pop                 edi

        $sequence_1 = { 4883c201 4983e901 0f855dfeffff 488d9424000a0000 }
            // n = 4, score = 200
            //   4883c201             | movzx               eax, byte ptr [edx]
            //   4983e901             | movzx               eax, word ptr [ebp + 0x27a10]
            //   0f855dfeffff         | mov                 word ptr [ecx + 8], ax
            //   488d9424000a0000     | movzx               eax, byte ptr [ebp + 0x27a12]

        $sequence_2 = { 030495c0e54200 eb05 b8???????? f6400420 }
            // n = 4, score = 200
            //   030495c0e54200       | add                 eax, dword ptr [edx*4 + 0x42e5c0]
            //   eb05                 | jmp                 7
            //   b8????????           |                     
            //   f6400420             | test                byte ptr [eax + 4], 0x20

        $sequence_3 = { 4883ec28 488d15056a0200 e8???????? 4885c0 }
            // n = 4, score = 200
            //   4883ec28             | dec                 eax
            //   488d15056a0200       | sub                 esp, 0x28
            //   e8????????           |                     
            //   4885c0               | dec                 eax

        $sequence_4 = { 0f84e4e30000 488b8500730200 488d8c2410600000 33d2 488901 8b8508730200 41b8f5000000 }
            // n = 7, score = 200
            //   0f84e4e30000         | dec                 ecx
            //   488b8500730200       | sub                 ecx, 1
            //   488d8c2410600000     | jne                 0xfffffe67
            //   33d2                 | dec                 eax
            //   488901               | lea                 edx, [esp + 0xa00]
            //   8b8508730200         | xor                 edx, edx
            //   41b8f5000000         | inc                 ecx

        $sequence_5 = { 0401 3cbe 8844240b 76e2 }
            // n = 4, score = 200
            //   0401                 | add                 al, 1
            //   3cbe                 | cmp                 al, 0xbe
            //   8844240b             | mov                 byte ptr [esp + 0xb], al
            //   76e2                 | jbe                 0xffffffe4

        $sequence_6 = { 033485c0e54200 8b45e4 8b00 8906 }
            // n = 4, score = 200
            //   033485c0e54200       | add                 esi, dword ptr [eax*4 + 0x42e5c0]
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8906                 | mov                 dword ptr [esi], eax

        $sequence_7 = { 03ce c6840c3801000000 8d8424a05c0000 33f6 }
            // n = 4, score = 200
            //   03ce                 | add                 ecx, esi
            //   c6840c3801000000     | mov                 byte ptr [esp + ecx + 0x138], 0
            //   8d8424a05c0000       | lea                 eax, [esp + 0x5ca0]
            //   33f6                 | xor                 esi, esi

        $sequence_8 = { 488bf3 48c1fe05 4c8d2547e50000 408afb 83e71f 48c1e706 }
            // n = 6, score = 200
            //   488bf3               | dec                 esp
            //   48c1fe05             | lea                 ebx, [0x20ae5]
            //   4c8d2547e50000       | dec                 ecx
            //   408afb               | mov                 ecx, esp
            //   83e71f               | je                  0xe3ea
            //   48c1e706             | dec                 eax

        $sequence_9 = { 00686c 42 0023 d18a0688078a }
            // n = 4, score = 200
            //   00686c               | add                 byte ptr [eax + 0x6c], ch
            //   42                   | inc                 edx
            //   0023                 | add                 byte ptr [ebx], ah
            //   d18a0688078a         | ror                 dword ptr [edx - 0x75f877fa], 1

        $sequence_10 = { 03c1 1bc9 0bc1 59 e9???????? e8???????? ff742404 }
            // n = 7, score = 200
            //   03c1                 | add                 eax, ecx
            //   1bc9                 | sbb                 ecx, ecx
            //   0bc1                 | or                  eax, ecx
            //   59                   | pop                 ecx
            //   e9????????           |                     
            //   e8????????           |                     
            //   ff742404             | push                dword ptr [esp + 4]

        $sequence_11 = { 4585c0 0f84b6010000 488d9424f05d0000 458bc8 66666690 66666690 0fb602 }
            // n = 7, score = 200
            //   4585c0               | lea                 edx, [0x26a05]
            //   0f84b6010000         | dec                 eax
            //   488d9424f05d0000     | test                eax, eax
            //   458bc8               | inc                 ebp
            //   66666690             | test                eax, eax
            //   66666690             | je                  0x1bf
            //   0fb602               | dec                 eax

        $sequence_12 = { 033485c0e54200 c745e401000000 33db 395e08 }
            // n = 4, score = 200
            //   033485c0e54200       | add                 esi, dword ptr [eax*4 + 0x42e5c0]
            //   c745e401000000       | mov                 dword ptr [ebp - 0x1c], 1
            //   33db                 | xor                 ebx, ebx
            //   395e08               | cmp                 dword ptr [esi + 8], ebx

        $sequence_13 = { 0fb785107a0200 66894108 0fb685127a0200 88410a 488d8c248b010000 }
            // n = 5, score = 200
            //   0fb785107a0200       | lea                 edx, [esp + 0x5df0]
            //   66894108             | inc                 ebp
            //   0fb685127a0200       | mov                 ecx, eax
            //   88410a               | nop                 
            //   488d8c248b010000     | nop                 

        $sequence_14 = { 33d2 41b803010000 4488a42460430000 488905???????? e8???????? 4c8d1de50a0200 498bcc }
            // n = 7, score = 200
            //   33d2                 | mov                 byte ptr [ecx + 0xa], al
            //   41b803010000         | dec                 eax
            //   4488a42460430000     | lea                 ecx, [esp + 0x18b]
            //   488905????????       |                     
            //   e8????????           |                     
            //   4c8d1de50a0200       | dec                 eax
            //   498bcc               | add                 edx, 1

        $sequence_15 = { 4489642430 4488a424100b0000 e8???????? 4c8d1dfcd60100 }
            // n = 4, score = 200
            //   4489642430           | mov                 eax, 0x103
            //   4488a424100b0000     | inc                 esp
            //   e8????????           |                     
            //   4c8d1dfcd60100       | mov                 byte ptr [esp + 0x4360], ah

    condition:
        7 of them and filesize < 434176
}