rule win_mediapi_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mediapi."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mediapi"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89c1 e8???????? 8045ff01 ebc3 }
            // n = 4, score = 100
            //   89c1                 | lea                 eax, [ebp + 0x320]
            //   e8????????           |                     
            //   8045ff01             | mov                 edx, 0x41
            //   ebc3                 | dec                 eax

        $sequence_1 = { 4898 488d95c0010000 41b900000000 41b8d0470000 4889c1 488b05???????? ffd0 }
            // n = 7, score = 100
            //   4898                 | lea                 eax, [ebp + 0x4990]
            //   488d95c0010000       | dec                 eax
            //   41b900000000         | mov                 dword ptr [ebp + 0xdd60], eax
            //   41b8d0470000         | dec                 eax
            //   4889c1               | mov                 eax, dword ptr [ebp + 0xdd60]
            //   488b05????????       |                     
            //   ffd0                 | dec                 eax

        $sequence_2 = { 488b5510 884209 488b5510 0fb645ff 88420d }
            // n = 5, score = 100
            //   488b5510             | mov                 eax, dword ptr [ebp - 0x10]
            //   884209               | add                 eax, 3
            //   488b5510             | inc                 ecx
            //   0fb645ff             | mov                 eax, eax
            //   88420d               | dec                 eax

        $sequence_3 = { 8345fc01 837dfc3b 0f86cdfdffff 90 4883c420 5d c3 }
            // n = 7, score = 100
            //   8345fc01             | dec                 eax
            //   837dfc3b             | mov                 ecx, eax
            //   0f86cdfdffff         | call                eax
            //   90                   | dec                 eax
            //   4883c420             | lea                 eax, [ebp + 0x9560]
            //   5d                   | mov                 edx, 0x47d0
            //   c3                   | dec                 eax

        $sequence_4 = { 88420b 488b5510 0fb645ff 884207 90 4883c410 }
            // n = 6, score = 100
            //   88420b               | dec                 eax
            //   488b5510             | cwde                
            //   0fb645ff             | movzx               eax, byte ptr [edx + eax*4 + 3]
            //   884207               | xor                 eax, ecx
            //   90                   | mov                 byte ptr [ebp - 4], al
            //   4883c410             | movzx               eax, byte ptr [ebp - 1]

        $sequence_5 = { 4889f1 ffd0 488b5b10 4885db 75dc 488d0d35600000 4883c428 }
            // n = 7, score = 100
            //   4889f1               | mov                 eax, 0x47d0
            //   ffd0                 | dec                 eax
            //   488b5b10             | mov                 ecx, eax
            //   4885db               | dec                 eax
            //   75dc                 | cwde                
            //   488d0d35600000       | dec                 eax
            //   4883c428             | lea                 edx, [ebp + 0x1c0]

        $sequence_6 = { 0fb645db 0fb6c0 c1f802 83e00f 01d0 }
            // n = 5, score = 100
            //   0fb645db             | mov                 byte ptr [edx + 0xa], al
            //   0fb6c0               | dec                 eax
            //   c1f802               | mov                 eax, dword ptr [ebp + 0x10]
            //   83e00f               | movzx               eax, byte ptr [eax + 6]
            //   01d0                 | mov                 byte ptr [ebp - 1], al

        $sequence_7 = { 90 488d0506700000 8b00 4898 488d9540010000 41b810000000 }
            // n = 6, score = 100
            //   90                   | mov                 byte ptr [ecx + edx], al
            //   488d0506700000       | dec                 eax
            //   8b00                 | add                 eax, edx
            //   4898                 | movzx               eax, byte ptr [eax]
            //   488d9540010000       | mov                 byte ptr [ebp - 0x14], al
            //   41b810000000         | mov                 eax, dword ptr [ebp - 8]

        $sequence_8 = { 8845de 0fb645db 0fb6c0 c1e006 89c2 0fb645dc 01d0 }
            // n = 7, score = 100
            //   8845de               | mov                 edx, dword ptr [ebp + 0x10]
            //   0fb645db             | mov                 byte ptr [edx + 9], al
            //   0fb6c0               | dec                 eax
            //   c1e006               | mov                 eax, dword ptr [ebp + 0x10]
            //   89c2                 | movzx               eax, byte ptr [eax + 1]
            //   0fb645dc             | dec                 eax
            //   01d0                 | mov                 edx, dword ptr [ebp + 0x10]

        $sequence_9 = { 8b05???????? c1e010 4898 48394518 }
            // n = 4, score = 100
            //   8b05????????         |                     
            //   c1e010               | mov                 edx, dword ptr [eax + 8]
            //   4898                 | dec                 eax
            //   48394518             | mov                 eax, dword ptr [eax]

    condition:
        7 of them and filesize < 246784
}