rule win_medusalocker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.medusalocker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.medusalocker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c408 8b5004 52 8b00 50 8d4dd8 e8???????? }
            // n = 7, score = 400
            //   83c408               | add                 esp, 8
            //   8b5004               | mov                 edx, dword ptr [eax + 4]
            //   52                   | push                edx
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   50                   | push                eax
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   e8????????           |                     

        $sequence_1 = { e8???????? c745fcffffffff 8d4d08 e8???????? 8a45eb }
            // n = 5, score = 400
            //   e8????????           |                     
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   8d4d08               | lea                 ecx, [ebp + 8]
            //   e8????????           |                     
            //   8a45eb               | mov                 al, byte ptr [ebp - 0x15]

        $sequence_2 = { eb24 33c9 894ddc 8d4ddc e8???????? 8945e0 }
            // n = 6, score = 400
            //   eb24                 | jmp                 0x26
            //   33c9                 | xor                 ecx, ecx
            //   894ddc               | mov                 dword ptr [ebp - 0x24], ecx
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   e8????????           |                     
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax

        $sequence_3 = { 05c8000000 8bc8 e8???????? 6a10 e8???????? 83c404 8945ec }
            // n = 7, score = 400
            //   05c8000000           | add                 eax, 0xc8
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   6a10                 | push                0x10
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax

        $sequence_4 = { 8d45ec 50 8b4d08 e8???????? 8b4de8 }
            // n = 5, score = 400
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   e8????????           |                     
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]

        $sequence_5 = { ff15???????? 85c0 7575 8b45c0 }
            // n = 4, score = 400
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7575                 | jne                 0x77
            //   8b45c0               | mov                 eax, dword ptr [ebp - 0x40]

        $sequence_6 = { 8b4dfc 8b11 8b4dfc 8b4210 ffd0 8be5 5d }
            // n = 7, score = 400
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b4210               | mov                 eax, dword ptr [edx + 0x10]
            //   ffd0                 | call                eax
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp

        $sequence_7 = { 83ec0c 894dfc 8b45fc 50 8b4d08 51 e8???????? }
            // n = 7, score = 400
            //   83ec0c               | sub                 esp, 0xc
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   50                   | push                eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_8 = { e8???????? 50 8b4dd0 e8???????? 50 }
            // n = 5, score = 400
            //   e8????????           |                     
            //   50                   | push                eax
            //   8b4dd0               | mov                 ecx, dword ptr [ebp - 0x30]
            //   e8????????           |                     
            //   50                   | push                eax

        $sequence_9 = { e8???????? 8b4df0 e8???????? c745fcffffffff 8d4d08 e8???????? }
            // n = 6, score = 400
            //   e8????????           |                     
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   e8????????           |                     
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   8d4d08               | lea                 ecx, [ebp + 8]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 1433600
}