rule win_meduza_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.meduza."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.meduza"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b8d7cf2ffff 0f288d90ebffff 898decf8ffff 8d8d90ebffff 8985e8f8ffff 8d5101 660fef8de0f8ffff }
            // n = 7, score = 100
            //   8b8d7cf2ffff         | mov                 ecx, dword ptr [ebp - 0xd84]
            //   0f288d90ebffff       | movaps              xmm1, xmmword ptr [ebp - 0x1470]
            //   898decf8ffff         | mov                 dword ptr [ebp - 0x714], ecx
            //   8d8d90ebffff         | lea                 ecx, [ebp - 0x1470]
            //   8985e8f8ffff         | mov                 dword ptr [ebp - 0x718], eax
            //   8d5101               | lea                 edx, [ecx + 1]
            //   660fef8de0f8ffff     | pxor                xmm1, xmmword ptr [ebp - 0x720]

        $sequence_1 = { 898db4f8ffff 8985b0f8ffff c78548f8ffff22b9d72e c7854cf8ffff97001a04 8b8548f8ffff 8b8d4cf8ffff c5fe6f8540f1ffff }
            // n = 7, score = 100
            //   898db4f8ffff         | mov                 dword ptr [ebp - 0x74c], ecx
            //   8985b0f8ffff         | mov                 dword ptr [ebp - 0x750], eax
            //   c78548f8ffff22b9d72e     | mov    dword ptr [ebp - 0x7b8], 0x2ed7b922
            //   c7854cf8ffff97001a04     | mov    dword ptr [ebp - 0x7b4], 0x41a0097
            //   8b8548f8ffff         | mov                 eax, dword ptr [ebp - 0x7b8]
            //   8b8d4cf8ffff         | mov                 ecx, dword ptr [ebp - 0x7b4]
            //   c5fe6f8540f1ffff     | vmovdqu             ymm0, ymmword ptr [ebp - 0xec0]

        $sequence_2 = { 898d54f9ffff c785d8e4ffff12b8295c c785dce4ffffd94ef7ef 8b85d8e4ffff 8b8ddce4ffff 898558f9ffff 898d5cf9ffff }
            // n = 7, score = 100
            //   898d54f9ffff         | mov                 dword ptr [ebp - 0x6ac], ecx
            //   c785d8e4ffff12b8295c     | mov    dword ptr [ebp - 0x1b28], 0x5c29b812
            //   c785dce4ffffd94ef7ef     | mov    dword ptr [ebp - 0x1b24], 0xeff74ed9
            //   8b85d8e4ffff         | mov                 eax, dword ptr [ebp - 0x1b28]
            //   8b8ddce4ffff         | mov                 ecx, dword ptr [ebp - 0x1b24]
            //   898558f9ffff         | mov                 dword ptr [ebp - 0x6a8], eax
            //   898d5cf9ffff         | mov                 dword ptr [ebp - 0x6a4], ecx

        $sequence_3 = { 0f288d00edffff 898d5cfaffff 8d8d00edffff 898558faffff 8d5101 660fef8d50faffff 0f298d00edffff }
            // n = 7, score = 100
            //   0f288d00edffff       | movaps              xmm1, xmmword ptr [ebp - 0x1300]
            //   898d5cfaffff         | mov                 dword ptr [ebp - 0x5a4], ecx
            //   8d8d00edffff         | lea                 ecx, [ebp - 0x1300]
            //   898558faffff         | mov                 dword ptr [ebp - 0x5a8], eax
            //   8d5101               | lea                 edx, [ecx + 1]
            //   660fef8d50faffff     | pxor                xmm1, xmmword ptr [ebp - 0x5b0]
            //   0f298d00edffff       | movaps              xmmword ptr [ebp - 0x1300], xmm1

        $sequence_4 = { 8b4908 8d5801 2bca 895de0 c1f904 b8ffffff0f 8bd1 }
            // n = 7, score = 100
            //   8b4908               | mov                 ecx, dword ptr [ecx + 8]
            //   8d5801               | lea                 ebx, [eax + 1]
            //   2bca                 | sub                 ecx, edx
            //   895de0               | mov                 dword ptr [ebp - 0x20], ebx
            //   c1f904               | sar                 ecx, 4
            //   b8ffffff0f           | mov                 eax, 0xfffffff
            //   8bd1                 | mov                 edx, ecx

        $sequence_5 = { 0f1f440000 8a01 41 84c0 75f9 2bca 8d8530e1ffff }
            // n = 7, score = 100
            //   0f1f440000           | nop                 dword ptr [eax + eax]
            //   8a01                 | mov                 al, byte ptr [ecx]
            //   41                   | inc                 ecx
            //   84c0                 | test                al, al
            //   75f9                 | jne                 0xfffffffb
            //   2bca                 | sub                 ecx, edx
            //   8d8530e1ffff         | lea                 eax, [ebp - 0x1ed0]

        $sequence_6 = { c78578fdffff88642bdd c7857cfdffff13203a28 8b8578fdffff 8b8d7cfdffff 898d2cfeffff 898528feffff c78578fdffff6d0b2891 }
            // n = 7, score = 100
            //   c78578fdffff88642bdd     | mov    dword ptr [ebp - 0x288], 0xdd2b6488
            //   c7857cfdffff13203a28     | mov    dword ptr [ebp - 0x284], 0x283a2013
            //   8b8578fdffff         | mov                 eax, dword ptr [ebp - 0x288]
            //   8b8d7cfdffff         | mov                 ecx, dword ptr [ebp - 0x284]
            //   898d2cfeffff         | mov                 dword ptr [ebp - 0x1d4], ecx
            //   898528feffff         | mov                 dword ptr [ebp - 0x1d8], eax
            //   c78578fdffff6d0b2891     | mov    dword ptr [ebp - 0x288], 0x91280b6d

        $sequence_7 = { 6aff 68???????? 64a100000000 50 53 81eca8060000 a1???????? }
            // n = 7, score = 100
            //   6aff                 | push                -1
            //   68????????           |                     
            //   64a100000000         | mov                 eax, dword ptr fs:[0]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   81eca8060000         | sub                 esp, 0x6a8
            //   a1????????           |                     

        $sequence_8 = { c5f8298d80f4ffff c5f81185e8e8ffff c785f8e8ffff00000000 c785fce8ffff00000000 c5f877 8a01 41 }
            // n = 7, score = 100
            //   c5f8298d80f4ffff     | vmovaps             xmmword ptr [ebp - 0xb80], xmm1
            //   c5f81185e8e8ffff     | vmovups             xmmword ptr [ebp - 0x1718], xmm0
            //   c785f8e8ffff00000000     | mov    dword ptr [ebp - 0x1708], 0
            //   c785fce8ffff00000000     | mov    dword ptr [ebp - 0x1704], 0
            //   c5f877               | vzeroupper          
            //   8a01                 | mov                 al, byte ptr [ecx]
            //   41                   | inc                 ecx

        $sequence_9 = { 51 52 e8???????? 83c408 eb08 85c9 0f85a9000000 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   eb08                 | jmp                 0xa
            //   85c9                 | test                ecx, ecx
            //   0f85a9000000         | jne                 0xaf

    condition:
        7 of them and filesize < 1433600
}