rule win_megacortex_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.megacortex."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.megacortex"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f843e040000 53 ff75e4 e8???????? 83c408 8945e0 85c0 }
            // n = 7, score = 400
            //   0f843e040000         | je                  0x444
            //   53                   | push                ebx
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   85c0                 | test                eax, eax

        $sequence_1 = { ff75c8 50 e8???????? 83c40c eb03 8b45c8 8b75b8 }
            // n = 7, score = 400
            //   ff75c8               | push                dword ptr [ebp - 0x38]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   eb03                 | jmp                 5
            //   8b45c8               | mov                 eax, dword ptr [ebp - 0x38]
            //   8b75b8               | mov                 esi, dword ptr [ebp - 0x48]

        $sequence_2 = { f7db 1bdb 23d8 8b4304 83c304 2bde 8d50ff }
            // n = 7, score = 400
            //   f7db                 | neg                 ebx
            //   1bdb                 | sbb                 ebx, ebx
            //   23d8                 | and                 ebx, eax
            //   8b4304               | mov                 eax, dword ptr [ebx + 4]
            //   83c304               | add                 ebx, 4
            //   2bde                 | sub                 ebx, esi
            //   8d50ff               | lea                 edx, [eax - 1]

        $sequence_3 = { 83c408 8d75fc 8b10 8d4aff f7d9 1bc9 }
            // n = 6, score = 400
            //   83c408               | add                 esp, 8
            //   8d75fc               | lea                 esi, [ebp - 4]
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   8d4aff               | lea                 ecx, [edx - 1]
            //   f7d9                 | neg                 ecx
            //   1bc9                 | sbb                 ecx, ecx

        $sequence_4 = { c3 8bc7 c745f801000000 8d4dec c745fc01000000 2bc1 8d7304 }
            // n = 7, score = 400
            //   c3                   | ret                 
            //   8bc7                 | mov                 eax, edi
            //   c745f801000000       | mov                 dword ptr [ebp - 8], 1
            //   8d4dec               | lea                 ecx, [ebp - 0x14]
            //   c745fc01000000       | mov                 dword ptr [ebp - 4], 1
            //   2bc1                 | sub                 eax, ecx
            //   8d7304               | lea                 esi, [ebx + 4]

        $sequence_5 = { f7da 1bd2 23d1 03d0 8d4d0c 2bf1 8d42ff }
            // n = 7, score = 400
            //   f7da                 | neg                 edx
            //   1bd2                 | sbb                 edx, edx
            //   23d1                 | and                 edx, ecx
            //   03d0                 | add                 edx, eax
            //   8d4d0c               | lea                 ecx, [ebp + 0xc]
            //   2bf1                 | sub                 esi, ecx
            //   8d42ff               | lea                 eax, [edx - 1]

        $sequence_6 = { f6430401 c645ff01 7506 8b45e4 894308 807dff00 0f8422030000 }
            // n = 7, score = 400
            //   f6430401             | test                byte ptr [ebx + 4], 1
            //   c645ff01             | mov                 byte ptr [ebp - 1], 1
            //   7506                 | jne                 8
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   894308               | mov                 dword ptr [ebx + 8], eax
            //   807dff00             | cmp                 byte ptr [ebp - 1], 0
            //   0f8422030000         | je                  0x328

        $sequence_7 = { eb3a 83fb0b 7507 68???????? eb2e 83fb30 7507 }
            // n = 7, score = 400
            //   eb3a                 | jmp                 0x3c
            //   83fb0b               | cmp                 ebx, 0xb
            //   7507                 | jne                 9
            //   68????????           |                     
            //   eb2e                 | jmp                 0x30
            //   83fb30               | cmp                 ebx, 0x30
            //   7507                 | jne                 9

        $sequence_8 = { 8d45d0 50 e8???????? 8d75e8 8b10 8d4aff f7d9 }
            // n = 7, score = 400
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d75e8               | lea                 esi, [ebp - 0x18]
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   8d4aff               | lea                 ecx, [edx - 1]
            //   f7d9                 | neg                 ecx

        $sequence_9 = { e8???????? 8d45b8 50 8d4e30 e8???????? 8b45d0 8d4d80 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   8d45b8               | lea                 eax, [ebp - 0x48]
            //   50                   | push                eax
            //   8d4e30               | lea                 ecx, [esi + 0x30]
            //   e8????????           |                     
            //   8b45d0               | mov                 eax, dword ptr [ebp - 0x30]
            //   8d4d80               | lea                 ecx, [ebp - 0x80]

    condition:
        7 of them and filesize < 1556480
}