rule win_megumin_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.megumin."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.megumin"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c418 c745fc04000000 bb1f000000 83781410 899de0feffff 7202 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   c745fc04000000       | mov                 dword ptr [ebp - 4], 4
            //   bb1f000000           | mov                 ebx, 0x1f
            //   83781410             | cmp                 dword ptr [eax + 0x14], 0x10
            //   899de0feffff         | mov                 dword ptr [ebp - 0x120], ebx
            //   7202                 | jb                  4

        $sequence_1 = { c1e81f c78570ffffff0f000000 c6855cffffff00 f20f5804c540814600 f20f5885f8feffff f20f1185f8feffff e8???????? }
            // n = 7, score = 200
            //   c1e81f               | shr                 eax, 0x1f
            //   c78570ffffff0f000000     | mov    dword ptr [ebp - 0x90], 0xf
            //   c6855cffffff00       | mov                 byte ptr [ebp - 0xa4], 0
            //   f20f5804c540814600     | addsd    xmm0, qword ptr [eax*8 + 0x468140]
            //   f20f5885f8feffff     | addsd               xmm0, qword ptr [ebp - 0x108]
            //   f20f1185f8feffff     | movsd               qword ptr [ebp - 0x108], xmm0
            //   e8????????           |                     

        $sequence_2 = { 3bc2 0f827a0c0000 2bce 2bc2 83c1fe 3bc1 0f42c8 }
            // n = 7, score = 200
            //   3bc2                 | cmp                 eax, edx
            //   0f827a0c0000         | jb                  0xc80
            //   2bce                 | sub                 ecx, esi
            //   2bc2                 | sub                 eax, edx
            //   83c1fe               | add                 ecx, -2
            //   3bc1                 | cmp                 eax, ecx
            //   0f42c8               | cmovb               ecx, eax

        $sequence_3 = { 6a03 68???????? 8d8da4fdffff e8???????? 83bdb8fdffff10 8d95a4fdffff ffb5b4fdffff }
            // n = 7, score = 200
            //   6a03                 | push                3
            //   68????????           |                     
            //   8d8da4fdffff         | lea                 ecx, [ebp - 0x25c]
            //   e8????????           |                     
            //   83bdb8fdffff10       | cmp                 dword ptr [ebp - 0x248], 0x10
            //   8d95a4fdffff         | lea                 edx, [ebp - 0x25c]
            //   ffb5b4fdffff         | push                dword ptr [ebp - 0x24c]

        $sequence_4 = { 8d4dc0 c645fc03 8bf0 e8???????? 85f6 0f844f010000 8b95e0fdffff }
            // n = 7, score = 200
            //   8d4dc0               | lea                 ecx, [ebp - 0x40]
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3
            //   8bf0                 | mov                 esi, eax
            //   e8????????           |                     
            //   85f6                 | test                esi, esi
            //   0f844f010000         | je                  0x155
            //   8b95e0fdffff         | mov                 edx, dword ptr [ebp - 0x220]

        $sequence_5 = { 68???????? e8???????? 8d7db8 8d4f01 0f1f4000 8a07 47 }
            // n = 7, score = 200
            //   68????????           |                     
            //   e8????????           |                     
            //   8d7db8               | lea                 edi, [ebp - 0x48]
            //   8d4f01               | lea                 ecx, [edi + 1]
            //   0f1f4000             | nop                 dword ptr [eax]
            //   8a07                 | mov                 al, byte ptr [edi]
            //   47                   | inc                 edi

        $sequence_6 = { c7461000000000 0f42bde0feffff 83bde4feffff10 57 0f438dd0feffff 51 c746140f000000 }
            // n = 7, score = 200
            //   c7461000000000       | mov                 dword ptr [esi + 0x10], 0
            //   0f42bde0feffff       | cmovb               edi, dword ptr [ebp - 0x120]
            //   83bde4feffff10       | cmp                 dword ptr [ebp - 0x11c], 0x10
            //   57                   | push                edi
            //   0f438dd0feffff       | cmovae              ecx, dword ptr [ebp - 0x130]
            //   51                   | push                ecx
            //   c746140f000000       | mov                 dword ptr [esi + 0x14], 0xf

        $sequence_7 = { 8d9570fbffff 2bd1 8a01 8d4901 88440aff 84c0 }
            // n = 6, score = 200
            //   8d9570fbffff         | lea                 edx, [ebp - 0x490]
            //   2bd1                 | sub                 edx, ecx
            //   8a01                 | mov                 al, byte ptr [ecx]
            //   8d4901               | lea                 ecx, [ecx + 1]
            //   88440aff             | mov                 byte ptr [edx + ecx - 1], al
            //   84c0                 | test                al, al

        $sequence_8 = { 8bcf ffb5c4fbffff 6a05 e8???????? 8bf8 c785bcfbffff00000000 c785c0fbffff00000000 }
            // n = 7, score = 200
            //   8bcf                 | mov                 ecx, edi
            //   ffb5c4fbffff         | push                dword ptr [ebp - 0x43c]
            //   6a05                 | push                5
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   c785bcfbffff00000000     | mov    dword ptr [ebp - 0x444], 0
            //   c785c0fbffff00000000     | mov    dword ptr [ebp - 0x440], 0

        $sequence_9 = { 0f8700010000 c1e003 3d00100000 721f 8d4823 3bc8 0f86f0000000 }
            // n = 7, score = 200
            //   0f8700010000         | ja                  0x106
            //   c1e003               | shl                 eax, 3
            //   3d00100000           | cmp                 eax, 0x1000
            //   721f                 | jb                  0x21
            //   8d4823               | lea                 ecx, [eax + 0x23]
            //   3bc8                 | cmp                 ecx, eax
            //   0f86f0000000         | jbe                 0xf6

    condition:
        7 of them and filesize < 1007616
}