rule win_meltingclaw_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.meltingclaw."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.meltingclaw"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f8484000000 ffc1 4c63e1 498bcc e8???????? }
            // n = 5, score = 200
            //   0f8484000000         | movzx               eax, word ptr [eax + edx*2]
            //   ffc1                 | cmp                 word ptr [ecx], di
            //   4c63e1               | jne                 0x11e1
            //   498bcc               | xor                 edx, edx
            //   e8????????           |                     

        $sequence_1 = { 488d8da8000000 48ffc9 48ffc1 803900 }
            // n = 4, score = 200
            //   488d8da8000000       | dec                 eax
            //   48ffc9               | mov                 dword ptr [ebp + 0x10a0], eax
            //   48ffc1               | dec                 eax
            //   803900               | mov                 esi, ecx

        $sequence_2 = { 33c9 ff15???????? 488d8d80000000 8bd8 e8???????? }
            // n = 5, score = 200
            //   33c9                 | je                  0x1950
            //   ff15????????         |                     
            //   488d8d80000000       | dec                 eax
            //   8bd8                 | mov                 ecx, eax
            //   e8????????           |                     

        $sequence_3 = { 8bfa 488bd9 33d2 41b804010000 488d4c2470 e8???????? 660f6f05???????? }
            // n = 7, score = 200
            //   8bfa                 | dec                 eax
            //   488bd9               | lea                 ebx, [0x1b20b]
            //   33d2                 | dec                 eax
            //   41b804010000         | lea                 edi, [0x1b204]
            //   488d4c2470           | jmp                 0x1d70
            //   e8????????           |                     
            //   660f6f05????????     |                     

        $sequence_4 = { 488364243000 4533c9 44896c2428 4533c0 8364242000 }
            // n = 5, score = 200
            //   488364243000         | mov                 dword ptr [ebp + 0x17c], 0x6c62616c
            //   4533c9               | mov                 word ptr [ebp + 0x180], 0x65
            //   44896c2428           | mov                 dword ptr [ebp + 0x17c], 0x6c62616c
            //   4533c0               | mov                 word ptr [ebp + 0x180], 0x65
            //   8364242000           | dec                 eax

        $sequence_5 = { 880411 48ffc2 84c0 75f3 488d8da8000000 }
            // n = 5, score = 200
            //   880411               | dec                 esp
            //   48ffc2               | lea                 eax, [0x11a29]
            //   84c0                 | and                 ecx, 0x3f
            //   75f3                 | dec                 eax
            //   488d8da8000000       | mov                 eax, edx

        $sequence_6 = { 23c1 41c1ff0c 2bc2 448bf0 418d6f01 4883ffff }
            // n = 6, score = 200
            //   23c1                 | xor                 ecx, esp
            //   41c1ff0c             | dec                 ecx
            //   2bc2                 | inc                 eax
            //   448bf0               | dec                 ecx
            //   418d6f01             | cmp                 eax, 0xa
            //   4883ffff             | jb                  0xc3

        $sequence_7 = { 80c121 418809 49ffc1 b90d000000 490fbe41ff 33d2 }
            // n = 6, score = 200
            //   80c121               | lea                 eax, [0x14e2c]
            //   418809               | dec                 eax
            //   49ffc1               | mov                 eax, ecx
            //   b90d000000           | and                 ecx, 0x3f
            //   490fbe41ff           | dec                 eax
            //   33d2                 | shr                 eax, 6

        $sequence_8 = { 750e 48396928 7508 48396930 b001 7403 }
            // n = 6, score = 200
            //   750e                 | dec                 eax
            //   48396928             | mov                 dword ptr [ebp + 0x10a0], eax
            //   7508                 | dec                 eax
            //   48396930             | mov                 esi, ecx
            //   b001                 | xor                 edx, edx
            //   7403                 | dec                 eax

        $sequence_9 = { 6bc83f 49c70700010000 80c121 418809 49ffc1 b90b000000 }
            // n = 6, score = 200
            //   6bc83f               | mov                 edx, dword ptr [ebp + 0x1a8]
            //   49c70700010000       | mov                 ebx, eax
            //   80c121               | dec                 eax
            //   418809               | cmp                 edx, 0x10
            //   49ffc1               | inc                 ebp
            //   b90b000000           | xor                 ecx, ecx

    condition:
        7 of them and filesize < 348160
}