rule win_miancha_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.miancha."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.miancha"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c744242000000000 ff15???????? 50 ff15???????? 8bf0 85f6 }
            // n = 6, score = 200
            //   c744242000000000     | mov                 dword ptr [esp + 0x20], 0
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi

        $sequence_1 = { 56 8b35???????? 6a02 6a00 68???????? }
            // n = 5, score = 200
            //   56                   | push                esi
            //   8b35????????         |                     
            //   6a02                 | push                2
            //   6a00                 | push                0
            //   68????????           |                     

        $sequence_2 = { ffd6 85c0 741a 837c241800 7413 }
            // n = 5, score = 200
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   741a                 | je                  0x1c
            //   837c241800           | cmp                 dword ptr [esp + 0x18], 0
            //   7413                 | je                  0x15

        $sequence_3 = { 68???????? c744242000000000 ff15???????? 50 ff15???????? 8bf0 85f6 }
            // n = 7, score = 200
            //   68????????           |                     
            //   c744242000000000     | mov                 dword ptr [esp + 0x20], 0
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi

        $sequence_4 = { 8b0d???????? 895008 8a15???????? 89480c }
            // n = 4, score = 200
            //   8b0d????????         |                     
            //   895008               | mov                 dword ptr [eax + 8], edx
            //   8a15????????         |                     
            //   89480c               | mov                 dword ptr [eax + 0xc], ecx

        $sequence_5 = { 52 6803000080 ff15???????? 85c0 741f }
            // n = 5, score = 200
            //   52                   | push                edx
            //   6803000080           | push                0x80000003
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   741f                 | je                  0x21

        $sequence_6 = { 8910 8b15???????? 894804 8b0d???????? 895008 8a15???????? 89480c }
            // n = 7, score = 200
            //   8910                 | mov                 dword ptr [eax], edx
            //   8b15????????         |                     
            //   894804               | mov                 dword ptr [eax + 4], ecx
            //   8b0d????????         |                     
            //   895008               | mov                 dword ptr [eax + 8], edx
            //   8a15????????         |                     
            //   89480c               | mov                 dword ptr [eax + 0xc], ecx

        $sequence_7 = { 85c0 741a 837c241800 7413 }
            // n = 4, score = 200
            //   85c0                 | test                eax, eax
            //   741a                 | je                  0x1c
            //   837c241800           | cmp                 dword ptr [esp + 0x18], 0
            //   7413                 | je                  0x15

        $sequence_8 = { ff15???????? 8bf0 85f6 7412 8d542418 }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   7412                 | je                  0x14
            //   8d542418             | lea                 edx, [esp + 0x18]

        $sequence_9 = { 40 50 56 8b35???????? 6a02 6a00 }
            // n = 6, score = 200
            //   40                   | inc                 eax
            //   50                   | push                eax
            //   56                   | push                esi
            //   8b35????????         |                     
            //   6a02                 | push                2
            //   6a00                 | push                0

    condition:
        7 of them and filesize < 376832
}