rule win_microbackdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.microbackdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.microbackdoor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c9 8d45f0 50 51 6a3a }
            // n = 5, score = 100
            //   33c9                 | mov                 eax, esi
            //   8d45f0               | dec                 eax
            //   50                   | mov                 edx, eax
            //   51                   | dec                 eax
            //   6a3a                 | mov                 ecx, edi

        $sequence_1 = { ffd7 eb06 ff15???????? 8bc6 eb06 }
            // n = 5, score = 100
            //   ffd7                 | add                 ecx, ecx
            //   eb06                 | dec                 ecx
            //   ff15????????         |                     
            //   8bc6                 | mov                 edx, edi
            //   eb06                 | dec                 ecx

        $sequence_2 = { eb42 0fb6442431 3c5a 7520 837c243400 7419 66837c243200 }
            // n = 7, score = 100
            //   eb42                 | lea                 ebp, [esp - 0x1f0]
            //   0fb6442431           | dec                 eax
            //   3c5a                 | sub                 esp, 0x2f0
            //   7520                 | mov                 ebx, ecx
            //   837c243400           | xor                 ecx, ecx
            //   7419                 | inc                 esp
            //   66837c243200         | movzx               ebp, dx

        $sequence_3 = { 488dac2410feffff 4881ecf0020000 8bd9 33c9 440fb7ea e8???????? }
            // n = 6, score = 100
            //   488dac2410feffff     | dec                 eax
            //   4881ecf0020000       | lea                 ecx, [esp + 0x50]
            //   8bd9                 | dec                 esp
            //   33c9                 | mov                 eax, eax
            //   440fb7ea             | dec                 eax
            //   e8????????           |                     

        $sequence_4 = { 418bce 0fb7de ff15???????? 488d15ea390000 488d4c2450 4c8bc0 }
            // n = 6, score = 100
            //   418bce               | inc                 ecx
            //   0fb7de               | mov                 ecx, esi
            //   ff15????????         |                     
            //   488d15ea390000       | movzx               ebx, si
            //   488d4c2450           | dec                 eax
            //   4c8bc0               | lea                 edx, [0x39ea]

        $sequence_5 = { 66896c2420 ff15???????? 8bce 89742424 }
            // n = 4, score = 100
            //   66896c2420           | jmp                 0x44
            //   ff15????????         |                     
            //   8bce                 | movzx               eax, byte ptr [esp + 0x31]
            //   89742424             | cmp                 al, 0x5a

        $sequence_6 = { 59 56 ff15???????? eb06 ff15???????? 8b75f4 }
            // n = 6, score = 100
            //   59                   | inc                 eax
            //   56                   | xor                 ecx, ecx
            //   ff15????????         |                     
            //   eb06                 | lea                 eax, [ebp - 0x10]
            //   ff15????????         |                     
            //   8b75f4               | push                eax

        $sequence_7 = { ff15???????? 488d0d01290000 eb68 488d542430 41b800010000 488bcb e8???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   488d0d01290000       | mov                 ecx, esi
            //   eb68                 | mov                 dword ptr [esp + 0x24], esi
            //   488d542430           | je                  0x14
            //   41b800010000         | dec                 eax
            //   488bcb               | lea                 ecx, [0x70fa]
            //   e8????????           |                     

        $sequence_8 = { 7412 488d0dfa700000 448bc0 488bd6 e8???????? 03df }
            // n = 6, score = 100
            //   7412                 | jne                 0x24
            //   488d0dfa700000       | cmp                 dword ptr [esp + 0x34], 0
            //   448bc0               | je                  0x24
            //   488bd6               | cmp                 word ptr [esp + 0x32], 0
            //   e8????????           |                     
            //   03df                 | mov                 word ptr [esp + 0x20], bp

        $sequence_9 = { ff15???????? 85c0 0f8599feffff 8d4508 33db 50 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   85c0                 | jmp                 0x3d
            //   0f8599feffff         | movzx               edx, al
            //   8d4508               | dec                 eax
            //   33db                 | lea                 ecx, [0x358c]
            //   50                   | jmp                 0x2b

        $sequence_10 = { eb57 4d03c9 498bd7 498bce 43ff54cd08 }
            // n = 5, score = 100
            //   eb57                 | inc                 esp
            //   4d03c9               | mov                 eax, eax
            //   498bd7               | dec                 eax
            //   498bce               | mov                 edx, esi
            //   43ff54cd08           | add                 ebx, edi

        $sequence_11 = { 448bc6 488bd0 488bcf e8???????? 8bf8 85c0 }
            // n = 6, score = 100
            //   448bc6               | dec                 eax
            //   488bd0               | lea                 ecx, [0x2901]
            //   488bcf               | jmp                 0x6a
            //   e8????????           |                     
            //   8bf8                 | dec                 eax
            //   85c0                 | lea                 edx, [esp + 0x30]

        $sequence_12 = { 3bfe 7cdd 33c0 40 }
            // n = 4, score = 100
            //   3bfe                 | mov                 ecx, esi
            //   7cdd                 | inc                 ebx
            //   33c0                 | call                dword ptr [ebp + ecx*8 + 8]
            //   40                   | inc                 esp

        $sequence_13 = { 895d08 e8???????? 83c410 85c0 7467 }
            // n = 5, score = 100
            //   895d08               | mov                 edi, eax
            //   e8????????           |                     
            //   83c410               | test                eax, eax
            //   85c0                 | dec                 eax
            //   7467                 | mov                 eax, ebx

        $sequence_14 = { ff15???????? ff75fc ff15???????? ff7508 ff15???????? eb0e ff15???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   ff75fc               | dec                 eax
            //   ff15????????         |                     
            //   ff7508               | lea                 ecx, [0x354b]
            //   ff15????????         |                     
            //   eb0e                 | call                edi
            //   ff15????????         |                     

        $sequence_15 = { 8975fc 50 56 56 6a19 ff75f8 ff15???????? }
            // n = 7, score = 100
            //   8975fc               | jmp                 0xa
            //   50                   | mov                 eax, esi
            //   56                   | jmp                 0xa
            //   56                   | cmp                 edi, esi
            //   6a19                 | jl                  0xffffffe1
            //   ff75f8               | xor                 eax, eax
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 123904
}