rule win_microcin_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.microcin."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.microcin"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c7461401000000 4d8d8680000000 418900 4989b688000000 41c7868400000004000000 4533c9 }
            // n = 6, score = 400
            //   c7461401000000       | push                esi
            //   4d8d8680000000       | test                eax, eax
            //   418900               | cmovne              esi, edi
            //   4989b688000000       | push                eax
            //   41c7868400000004000000     | call    ebx
            //   4533c9               | test                eax, eax

        $sequence_1 = { ff15???????? 488bcb 664489642438 488bf0 ff15???????? 0fb7cf }
            // n = 6, score = 400
            //   ff15????????         |                     
            //   488bcb               | jle                 0x1f
            //   664489642438         | push                0x104
            //   488bf0               | push                eax
            //   ff15????????         |                     
            //   0fb7cf               | lea                 eax, [ebp - 0x108]

        $sequence_2 = { 897e04 5b 5f 5e 5d c20400 55 }
            // n = 7, score = 400
            //   897e04               | int3                
            //   5b                   | dec                 esp
            //   5f                   | lea                 eax, [0x1126c]
            //   5e                   | dec                 ecx
            //   5d                   | mov                 edx, esp
            //   c20400               | dec                 eax
            //   55                   | mov                 ecx, ebp

        $sequence_3 = { 8d45ac 50 6801000080 ff15???????? }
            // n = 4, score = 400
            //   8d45ac               | sub                 esp, 0x20
            //   50                   | mov                 ebx, ecx
            //   6801000080           | mov                 ecx, ebx
            //   ff15????????         |                     

        $sequence_4 = { 85c0 7e18 80bc35a8feffff3a 741f 8d85a8feffff }
            // n = 5, score = 400
            //   85c0                 | jmp                 dword ptr [eax*4 + 0x4017d8]
            //   7e18                 | mov                 dword ptr [ebp - 0x14c], 0
            //   80bc35a8feffff3a     | push                eax
            //   741f                 | push                esi
            //   8d85a8feffff         | test                eax, eax

        $sequence_5 = { ff15???????? 4863c8 c6840d8002000068 488d8d80020000 }
            // n = 4, score = 400
            //   ff15????????         |                     
            //   4863c8               | test                eax, eax
            //   c6840d8002000068     | jle                 0x1f
            //   488d8d80020000       | cmp                 byte ptr [ebp + esi - 0x158], 0x3a

        $sequence_6 = { 488b0d???????? ff15???????? 4885c0 742b 488b4018 }
            // n = 5, score = 400
            //   488b0d????????       |                     
            //   ff15????????         |                     
            //   4885c0               | jle                 0x1c
            //   742b                 | lea                 eax, [ebp - 0x54]
            //   488b4018             | push                eax

        $sequence_7 = { 4885c0 742b 488b4018 488b08 8b09 ff15???????? 488bf8 }
            // n = 7, score = 400
            //   4885c0               | push                esi
            //   742b                 | call                esi
            //   488b4018             | push                4
            //   488b08               | call                ebx
            //   8b09                 | test                eax, eax
            //   ff15????????         |                     
            //   488bf8               | jle                 0x1a

        $sequence_8 = { 50 6805100000 68ffff0000 56 8b35???????? ffd6 }
            // n = 6, score = 400
            //   50                   | inc                 ecx
            //   6805100000           | lea                 edx, [eax + 1]
            //   68ffff0000           | inc                 eax
            //   56                   | push                ebx
            //   8b35????????         |                     
            //   ffd6                 | dec                 eax

        $sequence_9 = { 8d85f8feffff 6804010000 50 ff15???????? 8d85f8feffff }
            // n = 5, score = 400
            //   8d85f8feffff         | push                0x128
            //   6804010000           | lea                 eax, [ebp - 0x134]
            //   50                   | push                0
            //   ff15????????         |                     
            //   8d85f8feffff         | push                eax

        $sequence_10 = { ff15???????? 4863c8 807c0c5f5c 7413 488d4c2460 ff15???????? 4863c8 }
            // n = 7, score = 400
            //   ff15????????         |                     
            //   4863c8               | cmp                 byte ptr [ebp + esi - 0x158], 0x3a
            //   807c0c5f5c           | push                0xffff
            //   7413                 | push                esi
            //   488d4c2460           | call                esi
            //   ff15????????         |                     
            //   4863c8               | push                4

        $sequence_11 = { ff15???????? 8b3d???????? 8d85e0feffff 50 }
            // n = 4, score = 400
            //   ff15????????         |                     
            //   8b3d????????         |                     
            //   8d85e0feffff         | lea                 eax, [ebp - 0x158]
            //   50                   | test                eax, eax

        $sequence_12 = { 33f6 50 ffd3 85c0 7e18 }
            // n = 5, score = 400
            //   33f6                 | push                eax
            //   50                   | push                esi
            //   ffd3                 | test                eax, eax
            //   85c0                 | cmovne              esi, edi
            //   7e18                 | push                eax

        $sequence_13 = { 488b05???????? 4833c4 488985f0040000 4c8b3d???????? 4533c0 8bfa }
            // n = 6, score = 400
            //   488b05????????       |                     
            //   4833c4               | lea                 eax, [ebp - 0x158]
            //   488985f0040000       | xor                 esi, esi
            //   4c8b3d????????       |                     
            //   4533c0               | push                eax
            //   8bfa                 | call                ebx

        $sequence_14 = { 8b1d???????? 8d85a8feffff 50 ffd3 }
            // n = 4, score = 400
            //   8b1d????????         |                     
            //   8d85a8feffff         | call                esi
            //   50                   | lea                 eax, [ebp - 0x54]
            //   ffd3                 | push                eax

        $sequence_15 = { 488b1d???????? 488903 48894308 488b0d???????? }
            // n = 4, score = 400
            //   488b1d????????       |                     
            //   488903               | push                0x10
            //   48894308             | push                eax
            //   488b0d????????       |                     

        $sequence_16 = { 7647 498bcd e8???????? 4c8d05b7120100 41b903000000 488d4c45bc 488bc1 }
            // n = 7, score = 200
            //   7647                 | mov                 edx, esp
            //   498bcd               | xor                 ecx, ecx
            //   e8????????           |                     
            //   4c8d05b7120100       | test                eax, eax
            //   41b903000000         | mov                 ebx, ecx
            //   488d4c45bc           | dec                 eax
            //   488bc1               | lea                 ecx, [0x10c95]

        $sequence_17 = { 6828010000 8d85ccfeffff 6a00 50 }
            // n = 4, score = 200
            //   6828010000           | push                0x128
            //   8d85ccfeffff         | lea                 eax, [ebp - 0x134]
            //   6a00                 | push                0
            //   50                   | push                eax

        $sequence_18 = { 488d0d950c0100 ff15???????? 4885c0 7419 }
            // n = 4, score = 200
            //   488d0d950c0100       | dec                 eax
            //   ff15????????         |                     
            //   4885c0               | mov                 ecx, ebp
            //   7419                 | inc                 ecx

        $sequence_19 = { 7419 488d15730c0100 488bc8 ff15???????? }
            // n = 4, score = 200
            //   7419                 | je                  0x1b
            //   488d15730c0100       | dec                 eax
            //   488bc8               | lea                 edx, [0x10c73]
            //   ff15????????         |                     

        $sequence_20 = { 7541 8b4df0 83c108 51 }
            // n = 4, score = 200
            //   7541                 | xor                 ecx, ecx
            //   8b4df0               | dec                 eax
            //   83c108               | mov                 dword ptr [esp + 0x20], esi
            //   51                   | int3                

        $sequence_21 = { 7370 696465726167656e 742e 657865 }
            // n = 4, score = 200
            //   7370                 | jae                 0x72
            //   696465726167656e     | imul                esp, dword ptr [ebp + 0x72], 0x6e656761
            //   742e                 | je                  0x30
            //   657865               | js                  0x68

        $sequence_22 = { 83ec08 894df8 c745fc00a40000 6a40 6800100000 }
            // n = 5, score = 200
            //   83ec08               | mov                 eax, ecx
            //   894df8               | dec                 ecx
            //   c745fc00a40000       | sub                 eax, ebp
            //   6a40                 | dec                 eax
            //   6800100000           | sar                 eax, 1

        $sequence_23 = { 53 53 56 43 }
            // n = 4, score = 200
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   56                   | push                esi
            //   43                   | inc                 ebx

        $sequence_24 = { 498bd5 ff15???????? 418d7c24e7 85c0 752a 4c8d0502130100 8bd7 }
            // n = 7, score = 200
            //   498bd5               | dec                 eax
            //   ff15????????         |                     
            //   418d7c24e7           | mov                 ecx, eax
            //   85c0                 | dec                 ecx
            //   752a                 | mov                 edx, ebp
            //   4c8d0502130100       | inc                 ecx
            //   8bd7                 | lea                 edi, [esp - 0x19]

        $sequence_25 = { 8b8c8d78feffff 890c90 ebc8 e9???????? 33c0 }
            // n = 5, score = 200
            //   8b8c8d78feffff       | test                eax, eax
            //   890c90               | dec                 eax
            //   ebc8                 | mov                 dword ptr [esp + 0x20], esi
            //   e9????????           |                     
            //   33c0                 | int3                

        $sequence_26 = { c745f46d737664 c745ec5f6c6569 0fbe4dee 83c101 884dee c745f872742e64 }
            // n = 6, score = 200
            //   c745f46d737664       | dec                 eax
            //   c745ec5f6c6569       | sub                 edi, eax
            //   0fbe4dee             | mov                 ebx, ecx
            //   83c101               | dec                 eax
            //   884dee               | lea                 ecx, [0x10c95]
            //   c745f872742e64       | dec                 eax

        $sequence_27 = { 8d8da0f4ffff e8???????? 8b8574dfffff 5e 8be5 }
            // n = 5, score = 200
            //   8d8da0f4ffff         | mov                 ecx, 3
            //   e8????????           |                     
            //   8b8574dfffff         | dec                 eax
            //   5e                   | lea                 ecx, [ebp + eax*2 - 0x44]
            //   8be5                 | dec                 eax

        $sequence_28 = { 8b4dfc 83c108 51 ff15???????? 8b4dfc }
            // n = 5, score = 200
            //   8b4dfc               | dec                 esp
            //   83c108               | lea                 eax, [0x1126c]
            //   51                   | dec                 ecx
            //   ff15????????         |                     
            //   8b4dfc               | mov                 edx, esp

        $sequence_29 = { 4883ec20 8bd9 488d0d950c0100 ff15???????? }
            // n = 4, score = 200
            //   4883ec20             | test                eax, eax
            //   8bd9                 | jne                 0x2e
            //   488d0d950c0100       | dec                 esp
            //   ff15????????         |                     

        $sequence_30 = { 8b4508 0fb608 81e107000080 7905 49 83c9f8 41 }
            // n = 7, score = 200
            //   8b4508               | jne                 0x1e
            //   0fb608               | dec                 eax
            //   81e107000080         | lea                 edx, [0x111f8]
            //   7905                 | inc                 ecx
            //   49                   | mov                 eax, 0x12010
            //   83c9f8               | dec                 eax
            //   41                   | mov                 ecx, ebp

        $sequence_31 = { e8???????? 85c0 751a 488d15f8110100 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   85c0                 | je                  0x1e
            //   751a                 | jbe                 0x49
            //   488d15f8110100       | dec                 ecx

        $sequence_32 = { e8???????? cc 4c8d056c120100 498bd4 488bcd }
            // n = 5, score = 200
            //   e8????????           |                     
            //   cc                   | mov                 ecx, ebp
            //   4c8d056c120100       | dec                 esp
            //   498bd4               | lea                 eax, [0x112b7]
            //   488bcd               | inc                 ecx

        $sequence_33 = { 83c208 52 ff15???????? 6a06 ff15???????? ebcd 8be5 }
            // n = 7, score = 200
            //   83c208               | dec                 esp
            //   52                   | lea                 eax, [0x1126c]
            //   ff15????????         |                     
            //   6a06                 | dec                 eax
            //   ff15????????         |                     
            //   ebcd                 | mov                 ecx, ebp
            //   8be5                 | test                eax, eax

        $sequence_34 = { 726f 6e 6d 656e 7400 }
            // n = 5, score = 200
            //   726f                 | jb                  0x71
            //   6e                   | outsb               dx, byte ptr [esi]
            //   6d                   | insd                dword ptr es:[edi], dx
            //   656e                 | outsb               dx, byte ptr gs:[esi]
            //   7400                 | je                  2

        $sequence_35 = { fa fa fa fa fa }
            // n = 5, score = 200
            //   fa                   | cli                 
            //   fa                   | cli                 
            //   fa                   | cli                 
            //   fa                   | cli                 
            //   fa                   | cli                 

        $sequence_36 = { 4c8d0574130100 488bcd 418bd4 e8???????? 33c9 85c0 }
            // n = 6, score = 200
            //   4c8d0574130100       | lea                 eax, [0x11302]
            //   488bcd               | mov                 edx, edi
            //   418bd4               | dec                 eax
            //   e8????????           |                     
            //   33c9                 | sub                 esp, 0x20
            //   85c0                 | mov                 ebx, ecx

        $sequence_37 = { 636373 7673 6873742e65 7865 }
            // n = 4, score = 200
            //   636373               | arpl                word ptr [ebx + 0x73], sp
            //   7673                 | jbe                 0x75
            //   6873742e65           | push                0x652e7473
            //   7865                 | js                  0x67

        $sequence_38 = { 660fd645ec 660fd645f4 3d89000000 0f87b2010000 0fb68030184000 ff2485d8174000 68???????? }
            // n = 7, score = 100
            //   660fd645ec           | xor                 eax, eax
            //   660fd645f4           | add                 edx, 8
            //   3d89000000           | push                edx
            //   0f87b2010000         | push                6
            //   0fb68030184000       | jmp                 0xffffffd1
            //   ff2485d8174000       | mov                 esp, ebp
            //   68????????           |                     

        $sequence_39 = { 63f6 48 89d9 6a08 41 58 4f }
            // n = 7, score = 100
            //   63f6                 | arpl                si, si
            //   48                   | dec                 eax
            //   89d9                 | mov                 ecx, ebx
            //   6a08                 | push                8
            //   41                   | inc                 ecx
            //   58                   | pop                 eax
            //   4f                   | dec                 edi

        $sequence_40 = { 50 56 c785a4fcffff24020000 ff15???????? 85c0 7431 }
            // n = 6, score = 100
            //   50                   | add                 esp, 8
            //   56                   | mov                 eax, dword ptr [ebp - 0x10]
            //   c785a4fcffff24020000     | and    eax, 2
            //   ff15????????         |                     
            //   85c0                 | mov                 dword ptr [ebp - 0x10], eax
            //   7431                 | jne                 0x1c

        $sequence_41 = { 8d85f0feffff 6a00 50 e8???????? 83c408 8d95f0feffff }
            // n = 6, score = 100
            //   8d85f0feffff         | add                 ecx, 8
            //   6a00                 | push                ecx
            //   50                   | mov                 ecx, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   83c408               | add                 ecx, 8
            //   8d95f0feffff         | push                ecx

        $sequence_42 = { 680000cf00 68???????? 8d842480000000 50 6a00 ff15???????? }
            // n = 6, score = 100
            //   680000cf00           | mov                 dword ptr [ebp - 8], 0x642e7472
            //   68????????           |                     
            //   8d842480000000       | mov                 ecx, dword ptr [ebp + ecx*4 - 0x188]
            //   50                   | mov                 dword ptr [eax + edx*4], ecx
            //   6a00                 | jmp                 0xffffffca
            //   ff15????????         |                     

        $sequence_43 = { 68???????? e8???????? 8b7508 c7465cf8814000 }
            // n = 4, score = 100
            //   68????????           |                     
            //   e8????????           |                     
            //   8b7508               | mov                 ecx, dword ptr [ebp - 4]
            //   c7465cf8814000       | push                edx

        $sequence_44 = { c785b4feffff00000000 ff15???????? 50 56 ff15???????? 85c0 7e0f }
            // n = 7, score = 100
            //   c785b4feffff00000000     | mov    eax, dword ptr [ebp + 8]
            //   ff15????????         |                     
            //   50                   | movzx               ecx, byte ptr [eax]
            //   56                   | and                 ecx, 0x80000007
            //   ff15????????         |                     
            //   85c0                 | jns                 0xd
            //   7e0f                 | dec                 ecx

        $sequence_45 = { e8???????? 3d1f047008 754e 49 8b4d08 49 8b5510 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   3d1f047008           | cmp                 eax, 0x870041f
            //   754e                 | jne                 0x50
            //   49                   | dec                 ecx
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   49                   | dec                 ecx
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]

        $sequence_46 = { 7523 56 8d44245c 50 }
            // n = 4, score = 100
            //   7523                 | or                  ecx, 0xfffffff8
            //   56                   | inc                 ecx
            //   8d44245c             | jne                 0x43
            //   50                   | mov                 ecx, dword ptr [ebp - 0x10]

        $sequence_47 = { 40 ebf8 55 8bec 8b450c }
            // n = 5, score = 100
            //   40                   | inc                 eax
            //   ebf8                 | jmp                 0xfffffffa
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_48 = { 8b4060 6a40 6800100000 680c200000 6a00 8945f8 }
            // n = 6, score = 100
            //   8b4060               | mov                 eax, dword ptr [eax + 0x60]
            //   6a40                 | push                0x40
            //   6800100000           | push                0x1000
            //   680c200000           | push                0x200c
            //   6a00                 | push                0
            //   8945f8               | mov                 dword ptr [ebp - 8], eax

        $sequence_49 = { 7521 4c 89e1 33d2 41 b800800000 41 }
            // n = 7, score = 100
            //   7521                 | jne                 0x23
            //   4c                   | dec                 esp
            //   89e1                 | mov                 ecx, esp
            //   33d2                 | xor                 edx, edx
            //   41                   | inc                 ecx
            //   b800800000           | mov                 eax, 0x8000
            //   41                   | inc                 ecx

    condition:
        7 of them and filesize < 417792
}