rule win_milkmaid_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.milkmaid."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.milkmaid"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4c2414 889c24dc280100 e8???????? 8d4c240c }
            // n = 4, score = 100
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   889c24dc280100       | mov                 byte ptr [esp + 0x128dc], bl
            //   e8????????           |                     
            //   8d4c240c             | lea                 ecx, [esp + 0xc]

        $sequence_1 = { 8d442408 57 50 e8???????? 83c404 33db 68???????? }
            // n = 7, score = 100
            //   8d442408             | lea                 eax, [esp + 8]
            //   57                   | push                edi
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   33db                 | xor                 ebx, ebx
            //   68????????           |                     

        $sequence_2 = { 8d4c2408 e8???????? 68???????? 8d4c2408 e8???????? 8b442404 6a00 }
            // n = 7, score = 100
            //   8d4c2408             | lea                 ecx, [esp + 8]
            //   e8????????           |                     
            //   68????????           |                     
            //   8d4c2408             | lea                 ecx, [esp + 8]
            //   e8????????           |                     
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   6a00                 | push                0

        $sequence_3 = { 8a8528280100 81e1ff0f0000 33db 84c0 8a5c2918 895c2428 }
            // n = 6, score = 100
            //   8a8528280100         | mov                 al, byte ptr [ebp + 0x12828]
            //   81e1ff0f0000         | and                 ecx, 0xfff
            //   33db                 | xor                 ebx, ebx
            //   84c0                 | test                al, al
            //   8a5c2918             | mov                 bl, byte ptr [ecx + ebp + 0x18]
            //   895c2428             | mov                 dword ptr [esp + 0x28], ebx

        $sequence_4 = { 50 ff15???????? 8b74241c 8d4c2404 51 8bce }
            // n = 6, score = 100
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b74241c             | mov                 esi, dword ptr [esp + 0x1c]
            //   8d4c2404             | lea                 ecx, [esp + 4]
            //   51                   | push                ecx
            //   8bce                 | mov                 ecx, esi

        $sequence_5 = { 8d4c240c c78424dc280100ffffffff e8???????? 33c0 8b8c24d4280100 5f }
            // n = 6, score = 100
            //   8d4c240c             | lea                 ecx, [esp + 0xc]
            //   c78424dc280100ffffffff     | mov    dword ptr [esp + 0x128dc], 0xffffffff
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   8b8c24d4280100       | mov                 ecx, dword ptr [esp + 0x128d4]
            //   5f                   | pop                 edi

        $sequence_6 = { 8b4c240c 50 51 8d8c2480000000 c68424e428010003 e8???????? }
            // n = 6, score = 100
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   8d8c2480000000       | lea                 ecx, [esp + 0x80]
            //   c68424e428010003     | mov                 byte ptr [esp + 0x128e4], 3
            //   e8????????           |                     

        $sequence_7 = { 6a00 6a1a 6a00 ff15???????? 6aff 8d4c2408 }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   6a1a                 | push                0x1a
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   6aff                 | push                -1
            //   8d4c2408             | lea                 ecx, [esp + 8]

    condition:
        7 of them and filesize < 65536
}