rule win_milum_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.milum."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.milum"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f85c1000000 8b7608 385e44 751c c6424401 c6464401 8b5104 }
            // n = 7, score = 400
            //   0f85c1000000         | jne                 0xc7
            //   8b7608               | mov                 esi, dword ptr [esi + 8]
            //   385e44               | cmp                 byte ptr [esi + 0x44], bl
            //   751c                 | jne                 0x1e
            //   c6424401             | mov                 byte ptr [edx + 0x44], 1
            //   c6464401             | mov                 byte ptr [esi + 0x44], 1
            //   8b5104               | mov                 edx, dword ptr [ecx + 4]

        $sequence_1 = { 53 8d9424bc000000 c741140f000000 895910 52 8819 e8???????? }
            // n = 7, score = 400
            //   53                   | push                ebx
            //   8d9424bc000000       | lea                 edx, [esp + 0xbc]
            //   c741140f000000       | mov                 dword ptr [ecx + 0x14], 0xf
            //   895910               | mov                 dword ptr [ecx + 0x10], ebx
            //   52                   | push                edx
            //   8819                 | mov                 byte ptr [ecx], bl
            //   e8????????           |                     

        $sequence_2 = { 89a570feffff 6aff 53 8d5508 897114 895910 52 }
            // n = 7, score = 400
            //   89a570feffff         | mov                 dword ptr [ebp - 0x190], esp
            //   6aff                 | push                -1
            //   53                   | push                ebx
            //   8d5508               | lea                 edx, [ebp + 8]
            //   897114               | mov                 dword ptr [ecx + 0x14], esi
            //   895910               | mov                 dword ptr [ecx + 0x10], ebx
            //   52                   | push                edx

        $sequence_3 = { 8b4214 2b4644 8b5218 8945e4 03c1 3bc2 7605 }
            // n = 7, score = 400
            //   8b4214               | mov                 eax, dword ptr [edx + 0x14]
            //   2b4644               | sub                 eax, dword ptr [esi + 0x44]
            //   8b5218               | mov                 edx, dword ptr [edx + 0x18]
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   03c1                 | add                 eax, ecx
            //   3bc2                 | cmp                 eax, edx
            //   7605                 | jbe                 7

        $sequence_4 = { 8b5604 52 c645fc06 e8???????? bf10000000 eb1b bf10000000 }
            // n = 7, score = 400
            //   8b5604               | mov                 edx, dword ptr [esi + 4]
            //   52                   | push                edx
            //   c645fc06             | mov                 byte ptr [ebp - 4], 6
            //   e8????????           |                     
            //   bf10000000           | mov                 edi, 0x10
            //   eb1b                 | jmp                 0x1d
            //   bf10000000           | mov                 edi, 0x10

        $sequence_5 = { 895e18 885e08 8b4df4 64890d00000000 59 5e 5b }
            // n = 7, score = 400
            //   895e18               | mov                 dword ptr [esi + 0x18], ebx
            //   885e08               | mov                 byte ptr [esi + 8], bl
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   59                   | pop                 ecx
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_6 = { 50 ba???????? e8???????? 8b850cfcffff a804 7414 8d4dc8 }
            // n = 7, score = 400
            //   50                   | push                eax
            //   ba????????           |                     
            //   e8????????           |                     
            //   8b850cfcffff         | mov                 eax, dword ptr [ebp - 0x3f4]
            //   a804                 | test                al, 4
            //   7414                 | je                  0x16
            //   8d4dc8               | lea                 ecx, [ebp - 0x38]

        $sequence_7 = { 7e16 8b4d08 8b55d8 c741180d000000 89511c 83791800 7509 }
            // n = 7, score = 400
            //   7e16                 | jle                 0x18
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b55d8               | mov                 edx, dword ptr [ebp - 0x28]
            //   c741180d000000       | mov                 dword ptr [ecx + 0x18], 0xd
            //   89511c               | mov                 dword ptr [ecx + 0x1c], edx
            //   83791800             | cmp                 dword ptr [ecx + 0x18], 0
            //   7509                 | jne                 0xb

        $sequence_8 = { c645fc17 50 8d4dc8 e8???????? c645fc03 8d8d04ffffff e8???????? }
            // n = 7, score = 400
            //   c645fc17             | mov                 byte ptr [ebp - 4], 0x17
            //   50                   | push                eax
            //   8d4dc8               | lea                 ecx, [ebp - 0x38]
            //   e8????????           |                     
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3
            //   8d8d04ffffff         | lea                 ecx, [ebp - 0xfc]
            //   e8????????           |                     

        $sequence_9 = { c745e000000000 c645d000 397e14 7314 8b4610 40 50 }
            // n = 7, score = 400
            //   c745e000000000       | mov                 dword ptr [ebp - 0x20], 0
            //   c645d000             | mov                 byte ptr [ebp - 0x30], 0
            //   397e14               | cmp                 dword ptr [esi + 0x14], edi
            //   7314                 | jae                 0x16
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]
            //   40                   | inc                 eax
            //   50                   | push                eax

    condition:
        7 of them and filesize < 1076224
}