rule win_miniasp_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.miniasp."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.miniasp"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4de8 e8???????? 0fb6c0 85c0 742f 8b45e8 }
            // n = 6, score = 100
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   e8????????           |                     
            //   0fb6c0               | movzx               eax, al
            //   85c0                 | test                eax, eax
            //   742f                 | je                  0x31
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]

        $sequence_1 = { 8a8d7bffffff 8808 8b4584 40 894584 8b4580 40 }
            // n = 7, score = 100
            //   8a8d7bffffff         | mov                 cl, byte ptr [ebp - 0x85]
            //   8808                 | mov                 byte ptr [eax], cl
            //   8b4584               | mov                 eax, dword ptr [ebp - 0x7c]
            //   40                   | inc                 eax
            //   894584               | mov                 dword ptr [ebp - 0x7c], eax
            //   8b4580               | mov                 eax, dword ptr [ebp - 0x80]
            //   40                   | inc                 eax

        $sequence_2 = { 75ef 8b45a0 2b459c 894594 6800000010 ff7594 ff7510 }
            // n = 7, score = 100
            //   75ef                 | jne                 0xfffffff1
            //   8b45a0               | mov                 eax, dword ptr [ebp - 0x60]
            //   2b459c               | sub                 eax, dword ptr [ebp - 0x64]
            //   894594               | mov                 dword ptr [ebp - 0x6c], eax
            //   6800000010           | push                0x10000000
            //   ff7594               | push                dword ptr [ebp - 0x6c]
            //   ff7510               | push                dword ptr [ebp + 0x10]

        $sequence_3 = { 8b45bc ffb0b4000000 8b45bc ffb088000000 8d4dfb e8???????? 8945fc }
            // n = 7, score = 100
            //   8b45bc               | mov                 eax, dword ptr [ebp - 0x44]
            //   ffb0b4000000         | push                dword ptr [eax + 0xb4]
            //   8b45bc               | mov                 eax, dword ptr [ebp - 0x44]
            //   ffb088000000         | push                dword ptr [eax + 0x88]
            //   8d4dfb               | lea                 ecx, [ebp - 5]
            //   e8????????           |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_4 = { 8b45f0 ffb088000000 e8???????? 83c40c 837df800 7463 }
            // n = 6, score = 100
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   ffb088000000         | push                dword ptr [eax + 0x88]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   7463                 | je                  0x65

        $sequence_5 = { 33c0 40 e9???????? 8b4510 25ffff0000 0fb7c0 8945b4 }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   e9????????           |                     
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   25ffff0000           | and                 eax, 0xffff
            //   0fb7c0               | movzx               eax, ax
            //   8945b4               | mov                 dword ptr [ebp - 0x4c], eax

        $sequence_6 = { 8b4dfc c6040820 8b45fc 40 8945fc }
            // n = 5, score = 100
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   c6040820             | mov                 byte ptr [eax + ecx], 0x20
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   40                   | inc                 eax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_7 = { 7432 68???????? 8b45f8 ffb0e8000000 e8???????? 59 59 }
            // n = 7, score = 100
            //   7432                 | je                  0x34
            //   68????????           |                     
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   ffb0e8000000         | push                dword ptr [eax + 0xe8]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx

        $sequence_8 = { 807ddf00 741f 8b45e0 8a4001 8845de 8b4de4 }
            // n = 6, score = 100
            //   807ddf00             | cmp                 byte ptr [ebp - 0x21], 0
            //   741f                 | je                  0x21
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   8a4001               | mov                 al, byte ptr [eax + 1]
            //   8845de               | mov                 byte ptr [ebp - 0x22], al
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]

        $sequence_9 = { 33c0 8b7df8 83c742 ab ab ab ab }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   8b7df8               | mov                 edi, dword ptr [ebp - 8]
            //   83c742               | add                 edi, 0x42
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax

    condition:
        7 of them and filesize < 139264
}