rule win_minibike_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.minibike."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.minibike"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 0f434520 6800008004 6a00 6a00 6a00 51 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   0f434520             | cmovae              eax, dword ptr [ebp + 0x20]
            //   6800008004           | push                0x4800000
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   51                   | push                ecx

        $sequence_1 = { 2bc2 3bc8 0f8758010000 8d040a 8bce 3bc6 0f43c8 }
            // n = 7, score = 100
            //   2bc2                 | sub                 eax, edx
            //   3bc8                 | cmp                 ecx, eax
            //   0f8758010000         | ja                  0x15e
            //   8d040a               | lea                 eax, [edx + ecx]
            //   8bce                 | mov                 ecx, esi
            //   3bc6                 | cmp                 eax, esi
            //   0f43c8               | cmovae              ecx, eax

        $sequence_2 = { 75bd 8b5508 8b451c 83f810 7227 8d4801 8bc2 }
            // n = 7, score = 100
            //   75bd                 | jne                 0xffffffbf
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b451c               | mov                 eax, dword ptr [ebp + 0x1c]
            //   83f810               | cmp                 eax, 0x10
            //   7227                 | jb                  0x29
            //   8d4801               | lea                 ecx, [eax + 1]
            //   8bc2                 | mov                 eax, edx

        $sequence_3 = { 8975b4 a801 742b e8???????? 6a00 c7461000000000 8bce }
            // n = 7, score = 100
            //   8975b4               | mov                 dword ptr [ebp - 0x4c], esi
            //   a801                 | test                al, 1
            //   742b                 | je                  0x2d
            //   e8????????           |                     
            //   6a00                 | push                0
            //   c7461000000000       | mov                 dword ptr [esi + 0x10], 0
            //   8bce                 | mov                 ecx, esi

        $sequence_4 = { 8985b4fdffff 51 0f57c0 c785ecfdffff00000000 8d8588fdffff 660fd685e4fdffff 0f2805???????? }
            // n = 7, score = 100
            //   8985b4fdffff         | mov                 dword ptr [ebp - 0x24c], eax
            //   51                   | push                ecx
            //   0f57c0               | xorps               xmm0, xmm0
            //   c785ecfdffff00000000     | mov    dword ptr [ebp - 0x214], 0
            //   8d8588fdffff         | lea                 eax, [ebp - 0x278]
            //   660fd685e4fdffff     | movq                qword ptr [ebp - 0x21c], xmm0
            //   0f2805????????       |                     

        $sequence_5 = { 2bc6 8bbda4feffff c1f802 898decfcffff 8985f8fcffff 85c0 7441 }
            // n = 7, score = 100
            //   2bc6                 | sub                 eax, esi
            //   8bbda4feffff         | mov                 edi, dword ptr [ebp - 0x15c]
            //   c1f802               | sar                 eax, 2
            //   898decfcffff         | mov                 dword ptr [ebp - 0x314], ecx
            //   8985f8fcffff         | mov                 dword ptr [ebp - 0x308], eax
            //   85c0                 | test                eax, eax
            //   7441                 | je                  0x43

        $sequence_6 = { 8b85c8fdffff 33c9 8bb5c4fdffff 2bc6 8bbdd0fdffff c1f802 898df4fcffff }
            // n = 7, score = 100
            //   8b85c8fdffff         | mov                 eax, dword ptr [ebp - 0x238]
            //   33c9                 | xor                 ecx, ecx
            //   8bb5c4fdffff         | mov                 esi, dword ptr [ebp - 0x23c]
            //   2bc6                 | sub                 eax, esi
            //   8bbdd0fdffff         | mov                 edi, dword ptr [ebp - 0x230]
            //   c1f802               | sar                 eax, 2
            //   898df4fcffff         | mov                 dword ptr [ebp - 0x30c], ecx

        $sequence_7 = { c7431000000000 c7431407000000 85c0 7568 50 68???????? 8bcb }
            // n = 7, score = 100
            //   c7431000000000       | mov                 dword ptr [ebx + 0x10], 0
            //   c7431407000000       | mov                 dword ptr [ebx + 0x14], 7
            //   85c0                 | test                eax, eax
            //   7568                 | jne                 0x6a
            //   50                   | push                eax
            //   68????????           |                     
            //   8bcb                 | mov                 ecx, ebx

        $sequence_8 = { eb06 8b95acfcffff 83fa08 7235 8b8d98fcffff 8d145502000000 8bc1 }
            // n = 7, score = 100
            //   eb06                 | jmp                 8
            //   8b95acfcffff         | mov                 edx, dword ptr [ebp - 0x354]
            //   83fa08               | cmp                 edx, 8
            //   7235                 | jb                  0x37
            //   8b8d98fcffff         | mov                 ecx, dword ptr [ebp - 0x368]
            //   8d145502000000       | lea                 edx, [edx*2 + 2]
            //   8bc1                 | mov                 eax, ecx

        $sequence_9 = { 83f81f 0f87e5020000 51 56 e8???????? 83c408 c745b800000000 }
            // n = 7, score = 100
            //   83f81f               | cmp                 eax, 0x1f
            //   0f87e5020000         | ja                  0x2eb
            //   51                   | push                ecx
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   c745b800000000       | mov                 dword ptr [ebp - 0x48], 0

    condition:
        7 of them and filesize < 574464
}