rule win_mirai_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mirai."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mirai"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b00 8b4dfc 668b00 668981a00b0000 8b4508 8b00 40 }
            // n = 7, score = 100
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   668b00               | mov                 ax, word ptr [eax]
            //   668981a00b0000       | mov                 word ptr [ecx + 0xba0], ax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   40                   | inc                 eax

        $sequence_1 = { e8???????? 59 50 ff7508 8b4da0 e8???????? 0fb6c0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8b4da0               | mov                 ecx, dword ptr [ebp - 0x60]
            //   e8????????           |                     
            //   0fb6c0               | movzx               eax, al

        $sequence_2 = { c3 8d88dfa9ffff 83f95d 7709 0fb704458ebf6b00 c3 8d90dfa8ffff }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   8d88dfa9ffff         | lea                 ecx, [eax - 0x5621]
            //   83f95d               | cmp                 ecx, 0x5d
            //   7709                 | ja                  0xb
            //   0fb704458ebf6b00     | movzx               eax, word ptr [eax*2 + 0x6bbf8e]
            //   c3                   | ret                 
            //   8d90dfa8ffff         | lea                 edx, [eax - 0x5721]

        $sequence_3 = { 8bcf e8???????? 8b38 85ff 7447 8b4f08 51 }
            // n = 7, score = 100
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8b38                 | mov                 edi, dword ptr [eax]
            //   85ff                 | test                edi, edi
            //   7447                 | je                  0x49
            //   8b4f08               | mov                 ecx, dword ptr [edi + 8]
            //   51                   | push                ecx

        $sequence_4 = { 8b9654040000 68b3fe654f 51 6a64 6a02 68???????? 52 }
            // n = 7, score = 100
            //   8b9654040000         | mov                 edx, dword ptr [esi + 0x454]
            //   68b3fe654f           | push                0x4f65feb3
            //   51                   | push                ecx
            //   6a64                 | push                0x64
            //   6a02                 | push                2
            //   68????????           |                     
            //   52                   | push                edx

        $sequence_5 = { 8bce e8???????? 8bf8 3bfb 0f840cffffff 8bce e8???????? }
            // n = 7, score = 100
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   3bfb                 | cmp                 edi, ebx
            //   0f840cffffff         | je                  0xffffff12
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     

        $sequence_6 = { c3 bac8c50000 663bc2 720a b9f0c50000 663bc1 7610 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   bac8c50000           | mov                 edx, 0xc5c8
            //   663bc2               | cmp                 ax, dx
            //   720a                 | jb                  0xc
            //   b9f0c50000           | mov                 ecx, 0xc5f0
            //   663bc1               | cmp                 ax, cx
            //   7610                 | jbe                 0x12

        $sequence_7 = { ff15???????? 8945fc 837dfc00 7c33 ff75f8 ff15???????? 8945fc }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   7c33                 | jl                  0x35
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_8 = { 8b85d4fdffff 8a00 8885cffdffff ff85d4fdffff 80bdcffdffff00 75e3 8b85d4fdffff }
            // n = 7, score = 100
            //   8b85d4fdffff         | mov                 eax, dword ptr [ebp - 0x22c]
            //   8a00                 | mov                 al, byte ptr [eax]
            //   8885cffdffff         | mov                 byte ptr [ebp - 0x231], al
            //   ff85d4fdffff         | inc                 dword ptr [ebp - 0x22c]
            //   80bdcffdffff00       | cmp                 byte ptr [ebp - 0x231], 0
            //   75e3                 | jne                 0xffffffe5
            //   8b85d4fdffff         | mov                 eax, dword ptr [ebp - 0x22c]

        $sequence_9 = { 8b5e08 eb12 8b4e08 8b4604 6a00 52 51 }
            // n = 7, score = 100
            //   8b5e08               | mov                 ebx, dword ptr [esi + 8]
            //   eb12                 | jmp                 0x14
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   6a00                 | push                0
            //   52                   | push                edx
            //   51                   | push                ecx

    condition:
        7 of them and filesize < 7086080
}