rule win_mirrorkey_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mirrorkey."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mirrorkey"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 8d4db8 c745cc0f000000 c745c800000000 c645b800 }
            // n = 5, score = 100
            //   56                   | push                esi
            //   8d4db8               | lea                 ecx, [ebp - 0x48]
            //   c745cc0f000000       | mov                 dword ptr [ebp - 0x34], 0xf
            //   c745c800000000       | mov                 dword ptr [ebp - 0x38], 0
            //   c645b800             | mov                 byte ptr [ebp - 0x48], 0

        $sequence_1 = { 50 68???????? 53 c745a400000000 e8???????? 0fbe4317 8d4da8 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   68????????           |                     
            //   53                   | push                ebx
            //   c745a400000000       | mov                 dword ptr [ebp - 0x5c], 0
            //   e8????????           |                     
            //   0fbe4317             | movsx               eax, byte ptr [ebx + 0x17]
            //   8d4da8               | lea                 ecx, [ebp - 0x58]

        $sequence_2 = { 8b06 eb02 8bc6 c60000 c745fc00000000 8bce a1???????? }
            // n = 7, score = 100
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   eb02                 | jmp                 4
            //   8bc6                 | mov                 eax, esi
            //   c60000               | mov                 byte ptr [eax], 0
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   8bce                 | mov                 ecx, esi
            //   a1????????           |                     

        $sequence_3 = { 7406 8a740608 eb03 8a76fc 85c0 752f }
            // n = 6, score = 100
            //   7406                 | je                  8
            //   8a740608             | mov                 dh, byte ptr [esi + eax + 8]
            //   eb03                 | jmp                 5
            //   8a76fc               | mov                 dh, byte ptr [esi - 4]
            //   85c0                 | test                eax, eax
            //   752f                 | jne                 0x31

        $sequence_4 = { 88442433 8d7808 0f1f440000 53 }
            // n = 4, score = 100
            //   88442433             | mov                 byte ptr [esp + 0x33], al
            //   8d7808               | lea                 edi, [eax + 8]
            //   0f1f440000           | nop                 dword ptr [eax + eax]
            //   53                   | push                ebx

        $sequence_5 = { 50 e8???????? ff75fc 8d45fc ff75f8 50 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   50                   | push                eax

        $sequence_6 = { 8b85f4feffff 33f6 3930 7446 33db }
            // n = 5, score = 100
            //   8b85f4feffff         | mov                 eax, dword ptr [ebp - 0x10c]
            //   33f6                 | xor                 esi, esi
            //   3930                 | cmp                 dword ptr [eax], esi
            //   7446                 | je                  0x48
            //   33db                 | xor                 ebx, ebx

        $sequence_7 = { 56 ff15???????? 5f 5e c7430400000000 }
            // n = 5, score = 100
            //   56                   | push                esi
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   c7430400000000       | mov                 dword ptr [ebx + 4], 0

        $sequence_8 = { 32d3 2503000080 7905 48 }
            // n = 4, score = 100
            //   32d3                 | xor                 dl, bl
            //   2503000080           | and                 eax, 0x80000003
            //   7905                 | jns                 7
            //   48                   | dec                 eax

        $sequence_9 = { 85c0 7405 8a0c06 eb03 8a4ef4 }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   7405                 | je                  7
            //   8a0c06               | mov                 cl, byte ptr [esi + eax]
            //   eb03                 | jmp                 5
            //   8a4ef4               | mov                 cl, byte ptr [esi - 0xc]

    condition:
        7 of them and filesize < 117760
}