rule win_misfox_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.misfox."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.misfox"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d85f4ebffff 50 8b8528e5ffff 8b048550870110 }
            // n = 4, score = 300
            //   8d85f4ebffff         | mov                 eax, dword ptr [edi + 8]
            //   50                   | lea                 edx, [edi + 4]
            //   8b8528e5ffff         | mov                 dword ptr [edx], eax
            //   8b048550870110       | mov                 eax, dword ptr [ebp - 0x48]

        $sequence_1 = { 8a0a 42 884dab 83f80b 0f877b020000 ff2485b4d30010 }
            // n = 6, score = 300
            //   8a0a                 | movzx               edx, byte ptr [ebp + 0x30]
            //   42                   | movzx               eax, byte ptr [ebp + 0x31]
            //   884dab               | inc                 cx
            //   83f80b               | imul                edx, ebp
            //   0f877b020000         | test                esi, esi
            //   ff2485b4d30010       | jne                 0xffffffec

        $sequence_2 = { 8947fc 894c9308 81fe00010000 7ccc }
            // n = 4, score = 300
            //   8947fc               | push                edx
            //   894c9308             | mov                 dword ptr [ebx], 0
            //   81fe00010000         | inc                 eax
            //   7ccc                 | mov                 cl, byte ptr [edx]

        $sequence_3 = { 85f6 75e8 8b5c2410 68???????? 8d8424e8000000 6a20 }
            // n = 6, score = 300
            //   85f6                 | inc                 ebp
            //   75e8                 | lea                 eax, [ecx + edx]
            //   8b5c2410             | inc                 ecx
            //   68????????           |                     
            //   8d8424e8000000       | sar                 eax, 0xa
            //   6a20                 | movups              xmmword ptr [ebp - 0x80], xmm0

        $sequence_4 = { 0f85a0000000 8b4c240c 8d542418 50 50 50 }
            // n = 6, score = 300
            //   0f85a0000000         | mov                 ebx, dword ptr [esp + 0x10]
            //   8b4c240c             | lea                 eax, [esp + 0xe8]
            //   8d542418             | push                0x20
            //   50                   | mov                 eax, dword ptr [esi]
            //   50                   | push                0x25
            //   50                   | inc                 eax

        $sequence_5 = { 8b06 6a25 40 50 8d45d0 50 }
            // n = 6, score = 300
            //   8b06                 | movsd               qword ptr [ebp - 0x70], xmm1
            //   6a25                 | mov                 dword ptr [ebp - 0x68], eax
            //   40                   | cmp                 byte ptr [eax + esi], 0
            //   50                   | jne                 0
            //   8d45d0               | dec                 esp
            //   50                   | mov                 eax, esi

        $sequence_6 = { 8d8c24a4000000 c784245003000000000000 e8???????? 8d4c246c }
            // n = 4, score = 300
            //   8d8c24a4000000       | push                eax
            //   c784245003000000000000     | lea    eax, [ebp - 0x30]
            //   e8????????           |                     
            //   8d4c246c             | push                eax

        $sequence_7 = { 8b4708 8d5704 8902 8b45b8 52 c70300000000 40 }
            // n = 7, score = 300
            //   8b4708               | dec                 eax
            //   8d5704               | lea                 edx, [esp + 0x38]
            //   8902                 | dec                 ecx
            //   8b45b8               | mov                 ecx, esi
            //   52                   | dec                 ecx
            //   c70300000000         | mov                 eax, esi
            //   40                   | jne                 0x40

        $sequence_8 = { ff15???????? 483305???????? 488d15cabc0000 488bcb }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   483305????????       |                     
            //   488d15cabc0000       | dec                 esp
            //   488bcb               | mov                 dword ptr [esp + 0x20], edi

        $sequence_9 = { 442bc8 b8b1f98cb3 41f7e9 b8b1f98cb3 458d0411 41c1f80a }
            // n = 6, score = 100
            //   442bc8               | mov                 edi, 1
            //   b8b1f98cb3           | jne                 0x28
            //   41f7e9               | dec                 esp
            //   b8b1f98cb3           | lea                 esi, [0x15005]
            //   458d0411             | dec                 ecx
            //   41c1f80a             | cmp                 ebx, esi

        $sequence_10 = { 4c897c2438 8b442440 89442430 4c897c2428 4c897c2420 4533c9 }
            // n = 6, score = 100
            //   4c897c2438           | dec                 esp
            //   8b442440             | mov                 dword ptr [esp + 0x38], edi
            //   89442430             | mov                 eax, dword ptr [esp + 0x40]
            //   4c897c2428           | mov                 dword ptr [esp + 0x30], eax
            //   4c897c2420           | dec                 esp
            //   4533c9               | mov                 dword ptr [esp + 0x28], edi

        $sequence_11 = { 4889442450 e8???????? 488d053cf90000 488d15b56c0100 }
            // n = 4, score = 100
            //   4889442450           | lea                 esp, [0x151af]
            //   e8????????           |                     
            //   488d053cf90000       | mov                 ebp, esi
            //   488d15b56c0100       | inc                 ecx

        $sequence_12 = { 7526 4c8d3505500100 493bde 7408 }
            // n = 4, score = 100
            //   7526                 | lea                 edx, [0xbcca]
            //   4c8d3505500100       | dec                 eax
            //   493bde               | mov                 ecx, ebx
            //   7408                 | dec                 esp

        $sequence_13 = { 803c3000 75f7 4c8bc6 488d542438 498bce e8???????? 498bc6 }
            // n = 7, score = 100
            //   803c3000             | dec                 eax
            //   75f7                 | lea                 eax, [0xf93c]
            //   4c8bc6               | dec                 eax
            //   488d542438           | lea                 edx, [0x16cb5]
            //   498bce               | inc                 esp
            //   e8????????           |                     
            //   498bc6               | sub                 ecx, eax

        $sequence_14 = { 0f114580 f20f100d???????? f20f114d90 8b05???????? 894598 }
            // n = 5, score = 100
            //   0f114580             | je                  0xd
            //   f20f100d????????     |                     
            //   f20f114d90           | dec                 eax
            //   8b05????????         |                     
            //   894598               | mov                 dword ptr [esp + 0x50], eax

        $sequence_15 = { e9???????? 4c8d25af510100 8bee 41bf01000000 }
            // n = 4, score = 100
            //   e9????????           |                     
            //   4c8d25af510100       | inc                 ebp
            //   8bee                 | xor                 ecx, ecx
            //   41bf01000000         | dec                 eax

    condition:
        7 of them and filesize < 266240
}