rule win_mistcloak_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mistcloak."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mistcloak"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b049590500110 f644082801 740b 56 e8???????? 59 8bf0 }
            // n = 7, score = 100
            //   8b049590500110       | mov                 eax, dword ptr [edx*4 + 0x10015090]
            //   f644082801           | test                byte ptr [eax + ecx + 0x28], 1
            //   740b                 | je                  0xd
            //   56                   | push                esi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8bf0                 | mov                 esi, eax

        $sequence_1 = { 660f282d???????? 660f59f5 660f28aa70100110 660f54e5 660f58fe 660f58fc }
            // n = 6, score = 100
            //   660f282d????????     |                     
            //   660f59f5             | mulpd               xmm6, xmm5
            //   660f28aa70100110     | movapd              xmm5, xmmword ptr [edx + 0x10011070]
            //   660f54e5             | andpd               xmm4, xmm5
            //   660f58fe             | addpd               xmm7, xmm6
            //   660f58fc             | addpd               xmm7, xmm4

        $sequence_2 = { 8b0c8590500110 8b45f8 807c012800 7d46 }
            // n = 4, score = 100
            //   8b0c8590500110       | mov                 ecx, dword ptr [eax*4 + 0x10015090]
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   807c012800           | cmp                 byte ptr [ecx + eax + 0x28], 0
            //   7d46                 | jge                 0x48

        $sequence_3 = { 0f85b1000000 8b4508 dd00 ebc2 c745e418120110 eb19 }
            // n = 6, score = 100
            //   0f85b1000000         | jne                 0xb7
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   dd00                 | fld                 qword ptr [eax]
            //   ebc2                 | jmp                 0xffffffc4
            //   c745e418120110       | mov                 dword ptr [ebp - 0x1c], 0x10011218
            //   eb19                 | jmp                 0x1b

        $sequence_4 = { 6bc618 57 8db8104e0110 57 }
            // n = 4, score = 100
            //   6bc618               | imul                eax, esi, 0x18
            //   57                   | push                edi
            //   8db8104e0110         | lea                 edi, [eax + 0x10014e10]
            //   57                   | push                edi

        $sequence_5 = { 7429 83e805 7415 83e801 0f8595010000 c745e408120110 }
            // n = 6, score = 100
            //   7429                 | je                  0x2b
            //   83e805               | sub                 eax, 5
            //   7415                 | je                  0x17
            //   83e801               | sub                 eax, 1
            //   0f8595010000         | jne                 0x19b
            //   c745e408120110       | mov                 dword ptr [ebp - 0x1c], 0x10011208

        $sequence_6 = { c745e408120110 e9???????? c745e404120110 e9???????? 894de0 c745e404120110 e9???????? }
            // n = 7, score = 100
            //   c745e408120110       | mov                 dword ptr [ebp - 0x1c], 0x10011208
            //   e9????????           |                     
            //   c745e404120110       | mov                 dword ptr [ebp - 0x1c], 0x10011204
            //   e9????????           |                     
            //   894de0               | mov                 dword ptr [ebp - 0x20], ecx
            //   c745e404120110       | mov                 dword ptr [ebp - 0x1c], 0x10011204
            //   e9????????           |                     

        $sequence_7 = { 85f6 7420 6bc618 57 8db8104e0110 57 }
            // n = 6, score = 100
            //   85f6                 | test                esi, esi
            //   7420                 | je                  0x22
            //   6bc618               | imul                eax, esi, 0x18
            //   57                   | push                edi
            //   8db8104e0110         | lea                 edi, [eax + 0x10014e10]
            //   57                   | push                edi

        $sequence_8 = { 8bc1 3914c5781a0110 7408 40 }
            // n = 4, score = 100
            //   8bc1                 | mov                 eax, ecx
            //   3914c5781a0110       | cmp                 dword ptr [eax*8 + 0x10011a78], edx
            //   7408                 | je                  0xa
            //   40                   | inc                 eax

        $sequence_9 = { 8b45b4 8b0c8590500110 8a043b 03ce 8b75dc 03cb 43 }
            // n = 7, score = 100
            //   8b45b4               | mov                 eax, dword ptr [ebp - 0x4c]
            //   8b0c8590500110       | mov                 ecx, dword ptr [eax*4 + 0x10015090]
            //   8a043b               | mov                 al, byte ptr [ebx + edi]
            //   03ce                 | add                 ecx, esi
            //   8b75dc               | mov                 esi, dword ptr [ebp - 0x24]
            //   03cb                 | add                 ecx, ebx
            //   43                   | inc                 ebx

    condition:
        7 of them and filesize < 196608
}