rule win_miuref_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.miuref."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.miuref"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b750c 81fe00020000 7204 33c0 eb73 53 bb00200000 }
            // n = 7, score = 200
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]
            //   81fe00020000         | cmp                 esi, 0x200
            //   7204                 | jb                  6
            //   33c0                 | xor                 eax, eax
            //   eb73                 | jmp                 0x75
            //   53                   | push                ebx
            //   bb00200000           | mov                 ebx, 0x2000

        $sequence_1 = { e8???????? 59 b9???????? 3b01 7445 83c104 81f9???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   b9????????           |                     
            //   3b01                 | cmp                 eax, dword ptr [ecx]
            //   7445                 | je                  0x47
            //   83c104               | add                 ecx, 4
            //   81f9????????         |                     

        $sequence_2 = { 50 ff742418 e8???????? ff742420 8bf0 56 e8???????? }
            // n = 7, score = 200
            //   50                   | push                eax
            //   ff742418             | push                dword ptr [esp + 0x18]
            //   e8????????           |                     
            //   ff742420             | push                dword ptr [esp + 0x20]
            //   8bf0                 | mov                 esi, eax
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_3 = { 8d45a8 83ec58 50 e8???????? ff7510 8d45a8 ff750c }
            // n = 7, score = 200
            //   8d45a8               | lea                 eax, [ebp - 0x58]
            //   83ec58               | sub                 esp, 0x58
            //   50                   | push                eax
            //   e8????????           |                     
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   8d45a8               | lea                 eax, [ebp - 0x58]
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_4 = { 8d45cc 50 ff15???????? 8b45fc 8b08 50 ff9180000000 }
            // n = 7, score = 200
            //   8d45cc               | lea                 eax, [ebp - 0x34]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   50                   | push                eax
            //   ff9180000000         | call                dword ptr [ecx + 0x80]

        $sequence_5 = { e8???????? ff75f4 e8???????? 8b45e8 83c418 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   e8????????           |                     
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   83c418               | add                 esp, 0x18

        $sequence_6 = { 7704 50 51 eb27 837d1400 750c 57 }
            // n = 7, score = 200
            //   7704                 | ja                  6
            //   50                   | push                eax
            //   51                   | push                ecx
            //   eb27                 | jmp                 0x29
            //   837d1400             | cmp                 dword ptr [ebp + 0x14], 0
            //   750c                 | jne                 0xe
            //   57                   | push                edi

        $sequence_7 = { 3bc3 7320 894508 8b450c 8b4d08 8d4c08c1 56 }
            // n = 7, score = 200
            //   3bc3                 | cmp                 eax, ebx
            //   7320                 | jae                 0x22
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8d4c08c1             | lea                 ecx, [eax + ecx - 0x3f]
            //   56                   | push                esi

        $sequence_8 = { e8???????? 59 6a00 8bf0 8d45fc 50 57 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   6a00                 | push                0
            //   8bf0                 | mov                 esi, eax
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   57                   | push                edi

        $sequence_9 = { e8???????? 53 e8???????? 33f6 56 e8???????? }
            // n = 6, score = 200
            //   e8????????           |                     
            //   53                   | push                ebx
            //   e8????????           |                     
            //   33f6                 | xor                 esi, esi
            //   56                   | push                esi
            //   e8????????           |                     

    condition:
        7 of them and filesize < 180224
}