rule win_mmon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mmon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mmon"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bf8 8b4710 3bc8 770d 83c8ff 8bf7 e8???????? }
            // n = 7, score = 100
            //   8bf8                 | mov                 edi, eax
            //   8b4710               | mov                 eax, dword ptr [edi + 0x10]
            //   3bc8                 | cmp                 ecx, eax
            //   770d                 | ja                  0xf
            //   83c8ff               | or                  eax, 0xffffffff
            //   8bf7                 | mov                 esi, edi
            //   e8????????           |                     

        $sequence_1 = { 837e0800 7610 8b4608 8d80ec584200 fe08 803800 }
            // n = 6, score = 100
            //   837e0800             | cmp                 dword ptr [esi + 8], 0
            //   7610                 | jbe                 0x12
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   8d80ec584200         | lea                 eax, [eax + 0x4258ec]
            //   fe08                 | dec                 byte ptr [eax]
            //   803800               | cmp                 byte ptr [eax], 0

        $sequence_2 = { e8???????? ebd2 8bc3 c1f805 8d3c85606a4200 8bf3 83e61f }
            // n = 7, score = 100
            //   e8????????           |                     
            //   ebd2                 | jmp                 0xffffffd4
            //   8bc3                 | mov                 eax, ebx
            //   c1f805               | sar                 eax, 5
            //   8d3c85606a4200       | lea                 edi, [eax*4 + 0x426a60]
            //   8bf3                 | mov                 esi, ebx
            //   83e61f               | and                 esi, 0x1f

        $sequence_3 = { ff15???????? 899ec0000000 899ec4000000 c786c8000000e0e74100 c786cc00000068ec4100 c786d0000000e8ed4100 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   899ec0000000         | mov                 dword ptr [esi + 0xc0], ebx
            //   899ec4000000         | mov                 dword ptr [esi + 0xc4], ebx
            //   c786c8000000e0e74100     | mov    dword ptr [esi + 0xc8], 0x41e7e0
            //   c786cc00000068ec4100     | mov    dword ptr [esi + 0xcc], 0x41ec68
            //   c786d0000000e8ed4100     | mov    dword ptr [esi + 0xd0], 0x41ede8

        $sequence_4 = { 68???????? 8d4df4 51 c745f440e24100 }
            // n = 4, score = 100
            //   68????????           |                     
            //   8d4df4               | lea                 ecx, [ebp - 0xc]
            //   51                   | push                ecx
            //   c745f440e24100       | mov                 dword ptr [ebp - 0xc], 0x41e240

        $sequence_5 = { 8bc8 894de4 85c9 747b 8b55d4 85d2 }
            // n = 6, score = 100
            //   8bc8                 | mov                 ecx, eax
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   85c9                 | test                ecx, ecx
            //   747b                 | je                  0x7d
            //   8b55d4               | mov                 edx, dword ptr [ebp - 0x2c]
            //   85d2                 | test                edx, edx

        $sequence_6 = { 83e71f c1e706 8b0485606a4200 8d44380c }
            // n = 4, score = 100
            //   83e71f               | and                 edi, 0x1f
            //   c1e706               | shl                 edi, 6
            //   8b0485606a4200       | mov                 eax, dword ptr [eax*4 + 0x426a60]
            //   8d44380c             | lea                 eax, [eax + edi + 0xc]

        $sequence_7 = { 8bc8 c1f905 8d3c8d606a4200 8bf0 83e61f c1e606 8b0f }
            // n = 7, score = 100
            //   8bc8                 | mov                 ecx, eax
            //   c1f905               | sar                 ecx, 5
            //   8d3c8d606a4200       | lea                 edi, [ecx*4 + 0x426a60]
            //   8bf0                 | mov                 esi, eax
            //   83e61f               | and                 esi, 0x1f
            //   c1e606               | shl                 esi, 6
            //   8b0f                 | mov                 ecx, dword ptr [edi]

        $sequence_8 = { 8b0d???????? 85c9 7406 8b55ec }
            // n = 4, score = 100
            //   8b0d????????         |                     
            //   85c9                 | test                ecx, ecx
            //   7406                 | je                  8
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]

        $sequence_9 = { 6a00 8bf1 c745d000000000 ff15???????? 8bf8 33c0 4f }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   8bf1                 | mov                 esi, ecx
            //   c745d000000000       | mov                 dword ptr [ebp - 0x30], 0
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   33c0                 | xor                 eax, eax
            //   4f                   | dec                 edi

    condition:
        7 of them and filesize < 356352
}