rule win_mocton_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mocton."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mocton"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4d10 e8???????? 8985e4e8ffff 8b85e4e8ffff 2b45a4 3b45dc 7202 }
            // n = 7, score = 100
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   e8????????           |                     
            //   8985e4e8ffff         | mov                 dword ptr [ebp - 0x171c], eax
            //   8b85e4e8ffff         | mov                 eax, dword ptr [ebp - 0x171c]
            //   2b45a4               | sub                 eax, dword ptr [ebp - 0x5c]
            //   3b45dc               | cmp                 eax, dword ptr [ebp - 0x24]
            //   7202                 | jb                  4

        $sequence_1 = { 83e801 8945d4 8b4dd4 0faf4de8 8b55e4 c1fa05 69d271460389 }
            // n = 7, score = 100
            //   83e801               | sub                 eax, 1
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   8b4dd4               | mov                 ecx, dword ptr [ebp - 0x2c]
            //   0faf4de8             | imul                ecx, dword ptr [ebp - 0x18]
            //   8b55e4               | mov                 edx, dword ptr [ebp - 0x1c]
            //   c1fa05               | sar                 edx, 5
            //   69d271460389         | imul                edx, edx, 0x89034671

        $sequence_2 = { 8b9524fcffff 69d2a44539db 33c0 81fa35ac0e36 0f9cc0 355ba30c98 7461 }
            // n = 7, score = 100
            //   8b9524fcffff         | mov                 edx, dword ptr [ebp - 0x3dc]
            //   69d2a44539db         | imul                edx, edx, 0xdb3945a4
            //   33c0                 | xor                 eax, eax
            //   81fa35ac0e36         | cmp                 edx, 0x360eac35
            //   0f9cc0               | setl                al
            //   355ba30c98           | xor                 eax, 0x980ca35b
            //   7461                 | je                  0x63

        $sequence_3 = { 2b45e4 33c9 3d6b76f951 0f9dc1 33d1 742c 8b55e4 }
            // n = 7, score = 100
            //   2b45e4               | sub                 eax, dword ptr [ebp - 0x1c]
            //   33c9                 | xor                 ecx, ecx
            //   3d6b76f951           | cmp                 eax, 0x51f9766b
            //   0f9dc1               | setge               cl
            //   33d1                 | xor                 edx, ecx
            //   742c                 | je                  0x2e
            //   8b55e4               | mov                 edx, dword ptr [ebp - 0x1c]

        $sequence_4 = { 8b95c8e9ffff 83c201 8995c8e9ffff eb4e 8b85c0e9ffff 83e801 8985c0e9ffff }
            // n = 7, score = 100
            //   8b95c8e9ffff         | mov                 edx, dword ptr [ebp - 0x1638]
            //   83c201               | add                 edx, 1
            //   8995c8e9ffff         | mov                 dword ptr [ebp - 0x1638], edx
            //   eb4e                 | jmp                 0x50
            //   8b85c0e9ffff         | mov                 eax, dword ptr [ebp - 0x1640]
            //   83e801               | sub                 eax, 1
            //   8985c0e9ffff         | mov                 dword ptr [ebp - 0x1640], eax

        $sequence_5 = { 83c104 894df8 8b55f8 3b55cc 0f8475060000 c745ac5aee3273 8b45ac }
            // n = 7, score = 100
            //   83c104               | add                 ecx, 4
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   3b55cc               | cmp                 edx, dword ptr [ebp - 0x34]
            //   0f8475060000         | je                  0x67b
            //   c745ac5aee3273       | mov                 dword ptr [ebp - 0x54], 0x7332ee5a
            //   8b45ac               | mov                 eax, dword ptr [ebp - 0x54]

        $sequence_6 = { c745c842fc81f2 c7459cea0bbd91 c745b0238aa931 8b55c8 c1fa03 0faf55b0 b886628d96 }
            // n = 7, score = 100
            //   c745c842fc81f2       | mov                 dword ptr [ebp - 0x38], 0xf281fc42
            //   c7459cea0bbd91       | mov                 dword ptr [ebp - 0x64], 0x91bd0bea
            //   c745b0238aa931       | mov                 dword ptr [ebp - 0x50], 0x31a98a23
            //   8b55c8               | mov                 edx, dword ptr [ebp - 0x38]
            //   c1fa03               | sar                 edx, 3
            //   0faf55b0             | imul                edx, dword ptr [ebp - 0x50]
            //   b886628d96           | mov                 eax, 0x968d6286

        $sequence_7 = { 898d70feffff 8b9570feffff 81c28029ab41 33c0 399570feffff 0f9dc0 338570feffff }
            // n = 7, score = 100
            //   898d70feffff         | mov                 dword ptr [ebp - 0x190], ecx
            //   8b9570feffff         | mov                 edx, dword ptr [ebp - 0x190]
            //   81c28029ab41         | add                 edx, 0x41ab2980
            //   33c0                 | xor                 eax, eax
            //   399570feffff         | cmp                 dword ptr [ebp - 0x190], edx
            //   0f9dc0               | setge               al
            //   338570feffff         | xor                 eax, dword ptr [ebp - 0x190]

        $sequence_8 = { 0355e4 8b45e4 d1f8 33c9 3b45e4 0f9ec1 33ca }
            // n = 7, score = 100
            //   0355e4               | add                 edx, dword ptr [ebp - 0x1c]
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   d1f8                 | sar                 eax, 1
            //   33c9                 | xor                 ecx, ecx
            //   3b45e4               | cmp                 eax, dword ptr [ebp - 0x1c]
            //   0f9ec1               | setle               cl
            //   33ca                 | xor                 ecx, edx

        $sequence_9 = { 33d2 3b8d8cfdffff 0f9cc2 81e2d70a7b03 81f21da6f69d 7419 8b854cfdffff }
            // n = 7, score = 100
            //   33d2                 | xor                 edx, edx
            //   3b8d8cfdffff         | cmp                 ecx, dword ptr [ebp - 0x274]
            //   0f9cc2               | setl                dl
            //   81e2d70a7b03         | and                 edx, 0x37b0ad7
            //   81f21da6f69d         | xor                 edx, 0x9df6a61d
            //   7419                 | je                  0x1b
            //   8b854cfdffff         | mov                 eax, dword ptr [ebp - 0x2b4]

    condition:
        7 of them and filesize < 573440
}