rule win_mofksys_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mofksys."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mofksys"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 50 ff15???????? 51 d91c24 ff15???????? 8bd0 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   51                   | push                ecx
            //   d91c24               | fstp                dword ptr [esp]
            //   ff15????????         |                     
            //   8bd0                 | mov                 edx, eax

        $sequence_1 = { c1e003 eb0c ff15???????? 8b8dfcfeffff 8b590c 8b0c03 03d8 }
            // n = 7, score = 100
            //   c1e003               | shl                 eax, 3
            //   eb0c                 | jmp                 0xe
            //   ff15????????         |                     
            //   8b8dfcfeffff         | mov                 ecx, dword ptr [ebp - 0x104]
            //   8b590c               | mov                 ebx, dword ptr [ecx + 0xc]
            //   8b0c03               | mov                 ecx, dword ptr [ebx + eax]
            //   03d8                 | add                 ebx, eax

        $sequence_2 = { c78558ffffff00000000 c745fcab000000 8b8d6cffffff 83c128 898d54ffffff c745fcac000000 ba???????? }
            // n = 7, score = 100
            //   c78558ffffff00000000     | mov    dword ptr [ebp - 0xa8], 0
            //   c745fcab000000       | mov                 dword ptr [ebp - 4], 0xab
            //   8b8d6cffffff         | mov                 ecx, dword ptr [ebp - 0x94]
            //   83c128               | add                 ecx, 0x28
            //   898d54ffffff         | mov                 dword ptr [ebp - 0xac], ecx
            //   c745fcac000000       | mov                 dword ptr [ebp - 4], 0xac
            //   ba????????           |                     

        $sequence_3 = { ff15???????? 8bd0 8d4db0 ff15???????? 8d8d50fdffff ff15???????? c745fc07000000 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8bd0                 | mov                 edx, eax
            //   8d4db0               | lea                 ecx, [ebp - 0x50]
            //   ff15????????         |                     
            //   8d8d50fdffff         | lea                 ecx, [ebp - 0x2b0]
            //   ff15????????         |                     
            //   c745fc07000000       | mov                 dword ptr [ebp - 4], 7

        $sequence_4 = { 8d4db4 ff15???????? e9???????? c745fc0a000000 833d????????00 }
            // n = 5, score = 100
            //   8d4db4               | lea                 ecx, [ebp - 0x4c]
            //   ff15????????         |                     
            //   e9????????           |                     
            //   c745fc0a000000       | mov                 dword ptr [ebp - 4], 0xa
            //   833d????????00       |                     

        $sequence_5 = { 83c410 6685f6 7413 668b0d???????? 51 ff15???????? e9???????? }
            // n = 7, score = 100
            //   83c410               | add                 esp, 0x10
            //   6685f6               | test                si, si
            //   7413                 | je                  0x15
            //   668b0d????????       |                     
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   e9????????           |                     

        $sequence_6 = { 50 8b4dc8 51 6a01 ff15???????? 50 8b55a4 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8b4dc8               | mov                 ecx, dword ptr [ebp - 0x38]
            //   51                   | push                ecx
            //   6a01                 | push                1
            //   ff15????????         |                     
            //   50                   | push                eax
            //   8b55a4               | mov                 edx, dword ptr [ebp - 0x5c]

        $sequence_7 = { c78540ffffff7ca44000 c78538ffffff08000000 ff15???????? 8b4dc0 68???????? 51 ffd7 }
            // n = 7, score = 100
            //   c78540ffffff7ca44000     | mov    dword ptr [ebp - 0xc0], 0x40a47c
            //   c78538ffffff08000000     | mov    dword ptr [ebp - 0xc8], 8
            //   ff15????????         |                     
            //   8b4dc0               | mov                 ecx, dword ptr [ebp - 0x40]
            //   68????????           |                     
            //   51                   | push                ecx
            //   ffd7                 | call                edi

        $sequence_8 = { 50 8b5508 8b02 50 e8???????? ffd7 8b4da4 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   50                   | push                eax
            //   e8????????           |                     
            //   ffd7                 | call                edi
            //   8b4da4               | mov                 ecx, dword ptr [ebp - 0x5c]

        $sequence_9 = { 52 ff15???????? 8bd0 8d4dcc ff15???????? c745fc27000000 8b4dc8 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8bd0                 | mov                 edx, eax
            //   8d4dcc               | lea                 ecx, [ebp - 0x34]
            //   ff15????????         |                     
            //   c745fc27000000       | mov                 dword ptr [ebp - 4], 0x27
            //   8b4dc8               | mov                 ecx, dword ptr [ebp - 0x38]

    condition:
        7 of them and filesize < 401408
}