rule win_mokes_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mokes."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mokes"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f30f7f442438 8b442438 3b442428 751e 8b442440 3b442430 7514 }
            // n = 7, score = 400
            //   f30f7f442438         | movdqu              xmmword ptr [esp + 0x38], xmm0
            //   8b442438             | mov                 eax, dword ptr [esp + 0x38]
            //   3b442428             | cmp                 eax, dword ptr [esp + 0x28]
            //   751e                 | jne                 0x20
            //   8b442440             | mov                 eax, dword ptr [esp + 0x40]
            //   3b442430             | cmp                 eax, dword ptr [esp + 0x30]
            //   7514                 | jne                 0x16

        $sequence_1 = { f20f5cd0 f20f58d1 f20f2cca 03c8 8d442430 894c2430 8b4c240c }
            // n = 7, score = 400
            //   f20f5cd0             | subsd               xmm2, xmm0
            //   f20f58d1             | addsd               xmm2, xmm1
            //   f20f2cca             | cvttsd2si           ecx, xmm2
            //   03c8                 | add                 ecx, eax
            //   8d442430             | lea                 eax, [esp + 0x30]
            //   894c2430             | mov                 dword ptr [esp + 0x30], ecx
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]

        $sequence_2 = { ffb6c8010000 e8???????? 8b8e0c010000 8b4104 397808 7417 3b7808 }
            // n = 7, score = 400
            //   ffb6c8010000         | push                dword ptr [esi + 0x1c8]
            //   e8????????           |                     
            //   8b8e0c010000         | mov                 ecx, dword ptr [esi + 0x10c]
            //   8b4104               | mov                 eax, dword ptr [ecx + 4]
            //   397808               | cmp                 dword ptr [eax + 8], edi
            //   7417                 | je                  0x19
            //   3b7808               | cmp                 edi, dword ptr [eax + 8]

        $sequence_3 = { f6450801 56 8bf1 57 8b7e04 7423 8b0d???????? }
            // n = 7, score = 400
            //   f6450801             | test                byte ptr [ebp + 8], 1
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   57                   | push                edi
            //   8b7e04               | mov                 edi, dword ptr [esi + 4]
            //   7423                 | je                  0x25
            //   8b0d????????         |                     

        $sequence_4 = { ff742420 ba04000000 53 8d4a28 e8???????? 8b6c2420 8bf0 }
            // n = 7, score = 400
            //   ff742420             | push                dword ptr [esp + 0x20]
            //   ba04000000           | mov                 edx, 4
            //   53                   | push                ebx
            //   8d4a28               | lea                 ecx, [edx + 0x28]
            //   e8????????           |                     
            //   8b6c2420             | mov                 ebp, dword ptr [esp + 0x20]
            //   8bf0                 | mov                 esi, eax

        $sequence_5 = { ff5030 8b4004 f780e000000000000200 7404 c6432b01 807c241b00 8b5c2454 }
            // n = 7, score = 400
            //   ff5030               | call                dword ptr [eax + 0x30]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   f780e000000000000200     | test    dword ptr [eax + 0xe0], 0x20000
            //   7404                 | je                  6
            //   c6432b01             | mov                 byte ptr [ebx + 0x2b], 1
            //   807c241b00           | cmp                 byte ptr [esp + 0x1b], 0
            //   8b5c2454             | mov                 ebx, dword ptr [esp + 0x54]

        $sequence_6 = { ffd0 83c410 8b74240c 8b542418 8bca 8b7c241c 81c11ff9ef9e }
            // n = 7, score = 400
            //   ffd0                 | call                eax
            //   83c410               | add                 esp, 0x10
            //   8b74240c             | mov                 esi, dword ptr [esp + 0xc]
            //   8b542418             | mov                 edx, dword ptr [esp + 0x18]
            //   8bca                 | mov                 ecx, edx
            //   8b7c241c             | mov                 edi, dword ptr [esp + 0x1c]
            //   81c11ff9ef9e         | add                 ecx, 0x9eeff91f

        $sequence_7 = { f77e6c 89542420 8b450c 8b7004 807e7000 7407 8bce }
            // n = 7, score = 400
            //   f77e6c               | idiv                dword ptr [esi + 0x6c]
            //   89542420             | mov                 dword ptr [esp + 0x20], edx
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b7004               | mov                 esi, dword ptr [eax + 4]
            //   807e7000             | cmp                 byte ptr [esi + 0x70], 0
            //   7407                 | je                  9
            //   8bce                 | mov                 ecx, esi

        $sequence_8 = { ff74240c 889018020000 8b8e5c010000 e8???????? 80be9a02000000 7517 ff7604 }
            // n = 7, score = 400
            //   ff74240c             | push                dword ptr [esp + 0xc]
            //   889018020000         | mov                 byte ptr [eax + 0x218], dl
            //   8b8e5c010000         | mov                 ecx, dword ptr [esi + 0x15c]
            //   e8????????           |                     
            //   80be9a02000000       | cmp                 byte ptr [esi + 0x29a], 0
            //   7517                 | jne                 0x19
            //   ff7604               | push                dword ptr [esi + 4]

        $sequence_9 = { f6c310 7410 83e3ef 8d4c242c 895c2414 e8???????? c7442458ffffffff }
            // n = 7, score = 400
            //   f6c310               | test                bl, 0x10
            //   7410                 | je                  0x12
            //   83e3ef               | and                 ebx, 0xffffffef
            //   8d4c242c             | lea                 ecx, [esp + 0x2c]
            //   895c2414             | mov                 dword ptr [esp + 0x14], ebx
            //   e8????????           |                     
            //   c7442458ffffffff     | mov                 dword ptr [esp + 0x58], 0xffffffff

    condition:
        7 of them and filesize < 18505728
}