rule win_mole_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mole."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mole"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 81bdf0fdffffc7a4d005 0f846a6a0000 81bdf0fdffffcba4d005 0f8478790000 e9???????? 81bdf0fdffffd0a6d005 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   81bdf0fdffffc7a4d005     | cmp    dword ptr [ebp - 0x210], 0x5d0a4c7
            //   0f846a6a0000         | je                  0x6a70
            //   81bdf0fdffffcba4d005     | cmp    dword ptr [ebp - 0x210], 0x5d0a4cb
            //   0f8478790000         | je                  0x797e
            //   e9????????           |                     
            //   81bdf0fdffffd0a6d005     | cmp    dword ptr [ebp - 0x210], 0x5d0a6d0

        $sequence_1 = { 8d85f0ebffff 03c1 8b8d14e5ffff 50 8b8530e5ffff 8b048578f64100 }
            // n = 6, score = 100
            //   8d85f0ebffff         | lea                 eax, [ebp - 0x1410]
            //   03c1                 | add                 eax, ecx
            //   8b8d14e5ffff         | mov                 ecx, dword ptr [ebp - 0x1aec]
            //   50                   | push                eax
            //   8b8530e5ffff         | mov                 eax, dword ptr [ebp - 0x1ad0]
            //   8b048578f64100       | mov                 eax, dword ptr [eax*4 + 0x41f678]

        $sequence_2 = { ff15???????? c745f800000000 c745fc00000000 6a00 6a18 68???????? }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   6a00                 | push                0
            //   6a18                 | push                0x18
            //   68????????           |                     

        $sequence_3 = { 52 ff15???????? 83c41c 6a01 8d85ecf0ffff 50 }
            // n = 6, score = 100
            //   52                   | push                edx
            //   ff15????????         |                     
            //   83c41c               | add                 esp, 0x1c
            //   6a01                 | push                1
            //   8d85ecf0ffff         | lea                 eax, [ebp - 0xf14]
            //   50                   | push                eax

        $sequence_4 = { 0f873b5a0000 8b8df0fdffff 0fb69130cd4000 ff249518cd4000 8b85f0fdffff }
            // n = 5, score = 100
            //   0f873b5a0000         | ja                  0x5a41
            //   8b8df0fdffff         | mov                 ecx, dword ptr [ebp - 0x210]
            //   0fb69130cd4000       | movzx               edx, byte ptr [ecx + 0x40cd30]
            //   ff249518cd4000       | jmp                 dword ptr [edx*4 + 0x40cd18]
            //   8b85f0fdffff         | mov                 eax, dword ptr [ebp - 0x210]

        $sequence_5 = { 898570faffff 83bd70faffffff 7431 6a00 8d8d44faffff 51 8b955cfaffff }
            // n = 7, score = 100
            //   898570faffff         | mov                 dword ptr [ebp - 0x590], eax
            //   83bd70faffffff       | cmp                 dword ptr [ebp - 0x590], -1
            //   7431                 | je                  0x33
            //   6a00                 | push                0
            //   8d8d44faffff         | lea                 ecx, [ebp - 0x5bc]
            //   51                   | push                ecx
            //   8b955cfaffff         | mov                 edx, dword ptr [ebp - 0x5a4]

        $sequence_6 = { 83bde8feffff02 750c c785dcfeffff07000000 eb46 83bde4feffff06 7515 83bde8feffff03 }
            // n = 7, score = 100
            //   83bde8feffff02       | cmp                 dword ptr [ebp - 0x118], 2
            //   750c                 | jne                 0xe
            //   c785dcfeffff07000000     | mov    dword ptr [ebp - 0x124], 7
            //   eb46                 | jmp                 0x48
            //   83bde4feffff06       | cmp                 dword ptr [ebp - 0x11c], 6
            //   7515                 | jne                 0x17
            //   83bde8feffff03       | cmp                 dword ptr [ebp - 0x118], 3

        $sequence_7 = { 0fb6822cb64000 ff24850cb64000 81bdf0fdffff596ad005 7746 81bdf0fdffff596ad005 0f848d5a0000 }
            // n = 6, score = 100
            //   0fb6822cb64000       | movzx               eax, byte ptr [edx + 0x40b62c]
            //   ff24850cb64000       | jmp                 dword ptr [eax*4 + 0x40b60c]
            //   81bdf0fdffff596ad005     | cmp    dword ptr [ebp - 0x210], 0x5d06a59
            //   7746                 | ja                  0x48
            //   81bdf0fdffff596ad005     | cmp    dword ptr [ebp - 0x210], 0x5d06a59
            //   0f848d5a0000         | je                  0x5a93

        $sequence_8 = { 7d0d 8a441918 888168c44100 41 ebe8 }
            // n = 5, score = 100
            //   7d0d                 | jge                 0xf
            //   8a441918             | mov                 al, byte ptr [ecx + ebx + 0x18]
            //   888168c44100         | mov                 byte ptr [ecx + 0x41c468], al
            //   41                   | inc                 ecx
            //   ebe8                 | jmp                 0xffffffea

        $sequence_9 = { 0f8473590000 e9???????? 81bdf0fdffffc360d305 7725 81bdf0fdffffc360d305 }
            // n = 5, score = 100
            //   0f8473590000         | je                  0x5979
            //   e9????????           |                     
            //   81bdf0fdffffc360d305     | cmp    dword ptr [ebp - 0x210], 0x5d360c3
            //   7725                 | ja                  0x27
            //   81bdf0fdffffc360d305     | cmp    dword ptr [ebp - 0x210], 0x5d360c3

    condition:
        7 of them and filesize < 297984
}