rule win_molerat_loader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.molerat_loader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.molerat_loader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4db8 c645fc34 e8???????? 68???????? 8d4dbc c645fc35 e8???????? }
            // n = 7, score = 100
            //   8d4db8               | lea                 ecx, [ebp - 0x48]
            //   c645fc34             | mov                 byte ptr [ebp - 4], 0x34
            //   e8????????           |                     
            //   68????????           |                     
            //   8d4dbc               | lea                 ecx, [ebp - 0x44]
            //   c645fc35             | mov                 byte ptr [ebp - 4], 0x35
            //   e8????????           |                     

        $sequence_1 = { 51 c645fc42 e8???????? 83c40c }
            // n = 4, score = 100
            //   51                   | push                ecx
            //   c645fc42             | mov                 byte ptr [ebp - 4], 0x42
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_2 = { 8b08 8b11 50 8b4204 ffd0 c644243409 8b44240c }
            // n = 7, score = 100
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   50                   | push                eax
            //   8b4204               | mov                 eax, dword ptr [edx + 4]
            //   ffd0                 | call                eax
            //   c644243409           | mov                 byte ptr [esp + 0x34], 9
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]

        $sequence_3 = { 56 a1???????? 33c4 50 8d84241c020000 64a300000000 6804010000 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   a1????????           |                     
            //   33c4                 | xor                 eax, esp
            //   50                   | push                eax
            //   8d84241c020000       | lea                 eax, [esp + 0x21c]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   6804010000           | push                0x104

        $sequence_4 = { 8d4c2450 c744242000000000 e8???????? 8d4c241c c644243802 e8???????? 8d442410 }
            // n = 7, score = 100
            //   8d4c2450             | lea                 ecx, [esp + 0x50]
            //   c744242000000000     | mov                 dword ptr [esp + 0x20], 0
            //   e8????????           |                     
            //   8d4c241c             | lea                 ecx, [esp + 0x1c]
            //   c644243802           | mov                 byte ptr [esp + 0x38], 2
            //   e8????????           |                     
            //   8d442410             | lea                 eax, [esp + 0x10]

        $sequence_5 = { ffb56cffffff c745fc02000000 e8???????? 3bc7 7585 56 ffb56cffffff }
            // n = 7, score = 100
            //   ffb56cffffff         | push                dword ptr [ebp - 0x94]
            //   c745fc02000000       | mov                 dword ptr [ebp - 4], 2
            //   e8????????           |                     
            //   3bc7                 | cmp                 eax, edi
            //   7585                 | jne                 0xffffff87
            //   56                   | push                esi
            //   ffb56cffffff         | push                dword ptr [ebp - 0x94]

        $sequence_6 = { ffd0 68???????? 8d8d08feffff e8???????? 8b8508feffff 83c0f0 }
            // n = 6, score = 100
            //   ffd0                 | call                eax
            //   68????????           |                     
            //   8d8d08feffff         | lea                 ecx, [ebp - 0x1f8]
            //   e8????????           |                     
            //   8b8508feffff         | mov                 eax, dword ptr [ebp - 0x1f8]
            //   83c0f0               | add                 eax, -0x10

        $sequence_7 = { c644241c02 8b442410 83c0f0 83c40c 8d500c 83c9ff f00fc10a }
            // n = 7, score = 100
            //   c644241c02           | mov                 byte ptr [esp + 0x1c], 2
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   83c0f0               | add                 eax, -0x10
            //   83c40c               | add                 esp, 0xc
            //   8d500c               | lea                 edx, [eax + 0xc]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   f00fc10a             | lock xadd           dword ptr [edx], ecx

        $sequence_8 = { 83c40c 68???????? 50 8d4de0 b330 51 885dfc }
            // n = 7, score = 100
            //   83c40c               | add                 esp, 0xc
            //   68????????           |                     
            //   50                   | push                eax
            //   8d4de0               | lea                 ecx, [ebp - 0x20]
            //   b330                 | mov                 bl, 0x30
            //   51                   | push                ecx
            //   885dfc               | mov                 byte ptr [ebp - 4], bl

        $sequence_9 = { 8b7d08 57 8d45e0 33f6 50 8975e8 }
            // n = 6, score = 100
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   57                   | push                edi
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   33f6                 | xor                 esi, esi
            //   50                   | push                eax
            //   8975e8               | mov                 dword ptr [ebp - 0x18], esi

    condition:
        7 of them and filesize < 688128
}