rule win_mongall_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mongall."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mongall"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 75ef 57 bf???????? e8???????? 6a7f }
            // n = 5, score = 100
            //   75ef                 | jne                 0xfffffff1
            //   57                   | push                edi
            //   bf????????           |                     
            //   e8????????           |                     
            //   6a7f                 | push                0x7f

        $sequence_1 = { 57 8bc2 c1f805 8b0485603f4100 8bfa 83e71f c1e706 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   8bc2                 | mov                 eax, edx
            //   c1f805               | sar                 eax, 5
            //   8b0485603f4100       | mov                 eax, dword ptr [eax*4 + 0x413f60]
            //   8bfa                 | mov                 edi, edx
            //   83e71f               | and                 edi, 0x1f
            //   c1e706               | shl                 edi, 6

        $sequence_2 = { 83c404 5e b801000000 5b c3 83f806 7543 }
            // n = 7, score = 100
            //   83c404               | add                 esp, 4
            //   5e                   | pop                 esi
            //   b801000000           | mov                 eax, 1
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   83f806               | cmp                 eax, 6
            //   7543                 | jne                 0x45

        $sequence_3 = { 83c40c 8bdf 895df4 85c0 }
            // n = 4, score = 100
            //   83c40c               | add                 esp, 0xc
            //   8bdf                 | mov                 ebx, edi
            //   895df4               | mov                 dword ptr [ebp - 0xc], ebx
            //   85c0                 | test                eax, eax

        $sequence_4 = { ff15???????? 85f6 7413 6a00 6a00 6a00 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   85f6                 | test                esi, esi
            //   7413                 | je                  0x15
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_5 = { 85f6 7fdf eb07 838de4fdffffff 83bdccfdffff00 8b9de0fdffff 7457 }
            // n = 7, score = 100
            //   85f6                 | test                esi, esi
            //   7fdf                 | jg                  0xffffffe1
            //   eb07                 | jmp                 9
            //   838de4fdffffff       | or                  dword ptr [ebp - 0x21c], 0xffffffff
            //   83bdccfdffff00       | cmp                 dword ptr [ebp - 0x234], 0
            //   8b9de0fdffff         | mov                 ebx, dword ptr [ebp - 0x220]
            //   7457                 | je                  0x59

        $sequence_6 = { c745fc00000000 8b7df8 85ff 7509 }
            // n = 4, score = 100
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   8b7df8               | mov                 edi, dword ptr [ebp - 8]
            //   85ff                 | test                edi, edi
            //   7509                 | jne                 0xb

        $sequence_7 = { c745fc00000000 8b7df8 85ff 7509 5f 5e }
            // n = 6, score = 100
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   8b7df8               | mov                 edi, dword ptr [ebp - 8]
            //   85ff                 | test                edi, edi
            //   7509                 | jne                 0xb
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_8 = { 0fbe8028e24000 83e00f eb02 33c0 }
            // n = 4, score = 100
            //   0fbe8028e24000       | movsx               eax, byte ptr [eax + 0x40e228]
            //   83e00f               | and                 eax, 0xf
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax

        $sequence_9 = { 33c9 68???????? 51 6a03 }
            // n = 4, score = 100
            //   33c9                 | xor                 ecx, ecx
            //   68????????           |                     
            //   51                   | push                ecx
            //   6a03                 | push                3

    condition:
        7 of them and filesize < 199680
}