rule win_montysthree_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.montysthree."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.montysthree"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3c09 7443 3c0d 743f 3c20 743b }
            // n = 6, score = 200
            //   3c09                 | cmp                 al, 9
            //   7443                 | je                  0x45
            //   3c0d                 | cmp                 al, 0xd
            //   743f                 | je                  0x41
            //   3c20                 | cmp                 al, 0x20
            //   743b                 | je                  0x3d

        $sequence_1 = { 5f 85f6 5e 0f94c0 5b c9 }
            // n = 6, score = 200
            //   5f                   | pop                 edi
            //   85f6                 | test                esi, esi
            //   5e                   | pop                 esi
            //   0f94c0               | sete                al
            //   5b                   | pop                 ebx
            //   c9                   | leave               

        $sequence_2 = { 8d4d08 e8???????? ff30 6a6d ebac 66395f04 7629 }
            // n = 7, score = 200
            //   8d4d08               | lea                 ecx, [ebp + 8]
            //   e8????????           |                     
            //   ff30                 | push                dword ptr [eax]
            //   6a6d                 | push                0x6d
            //   ebac                 | jmp                 0xffffffae
            //   66395f04             | cmp                 word ptr [edi + 4], bx
            //   7629                 | jbe                 0x2b

        $sequence_3 = { c745f010000000 ff15???????? 85c0 8b35???????? 756e ffd6 3d16000980 }
            // n = 7, score = 200
            //   c745f010000000       | mov                 dword ptr [ebp - 0x10], 0x10
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   8b35????????         |                     
            //   756e                 | jne                 0x70
            //   ffd6                 | call                esi
            //   3d16000980           | cmp                 eax, 0x80090016

        $sequence_4 = { 83ec18 68???????? e8???????? 59 8d4de8 e8???????? }
            // n = 6, score = 200
            //   83ec18               | sub                 esp, 0x18
            //   68????????           |                     
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8d4de8               | lea                 ecx, [ebp - 0x18]
            //   e8????????           |                     

        $sequence_5 = { 68???????? e8???????? 33f6 8975fc 3935???????? 0f850a010000 56 }
            // n = 7, score = 200
            //   68????????           |                     
            //   e8????????           |                     
            //   33f6                 | xor                 esi, esi
            //   8975fc               | mov                 dword ptr [ebp - 4], esi
            //   3935????????         |                     
            //   0f850a010000         | jne                 0x110
            //   56                   | push                esi

        $sequence_6 = { 397dc8 7427 837dc802 7421 68???????? }
            // n = 5, score = 200
            //   397dc8               | cmp                 dword ptr [ebp - 0x38], edi
            //   7427                 | je                  0x29
            //   837dc802             | cmp                 dword ptr [ebp - 0x38], 2
            //   7421                 | je                  0x23
            //   68????????           |                     

        $sequence_7 = { 56 57 ff7510 33ff ff750c 33f6 }
            // n = 6, score = 200
            //   56                   | push                esi
            //   57                   | push                edi
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   33ff                 | xor                 edi, edi
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   33f6                 | xor                 esi, esi

        $sequence_8 = { 885d77 f6456c02 7408 8d4d3c e8???????? 385d77 }
            // n = 6, score = 200
            //   885d77               | mov                 byte ptr [ebp + 0x77], bl
            //   f6456c02             | test                byte ptr [ebp + 0x6c], 2
            //   7408                 | je                  0xa
            //   8d4d3c               | lea                 ecx, [ebp + 0x3c]
            //   e8????????           |                     
            //   385d77               | cmp                 byte ptr [ebp + 0x77], bl

        $sequence_9 = { 8d4ddc 895dfc e8???????? 395d08 742c 53 8d45fc }
            // n = 7, score = 200
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   e8????????           |                     
            //   395d08               | cmp                 dword ptr [ebp + 8], ebx
            //   742c                 | je                  0x2e
            //   53                   | push                ebx
            //   8d45fc               | lea                 eax, [ebp - 4]

    condition:
        7 of them and filesize < 458752
}