rule win_moontag_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.moontag."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.moontag"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4833c4 4889842430040000 488bd9 498d7b10 e8???????? 48897c2428 }
            // n = 6, score = 200
            //   4833c4               | mov                 eax, dword ptr [edx + 8]
            //   4889842430040000     | dec                 ecx
            //   488bd9               | mov                 dword ptr [eax + 8], eax
            //   498d7b10             | dec                 eax
            //   e8????????           |                     
            //   48897c2428           | mov                 esi, dword ptr [esi]

        $sequence_1 = { 4885d2 480f4415???????? 483b15???????? 480f4405???????? 488905???????? c3 4885c9 }
            // n = 7, score = 200
            //   4885d2               | pop                 edi
            //   480f4415????????     |                     
            //   483b15????????       |                     
            //   480f4405????????     |                     
            //   488905????????       |                     
            //   c3                   | ret                 
            //   4885c9               | dec                 eax

        $sequence_2 = { 4881ec60010000 488b05???????? 4833c4 48894550 488d4c2440 }
            // n = 5, score = 200
            //   4881ec60010000       | dec                 eax
            //   488b05????????       |                     
            //   4833c4               | mov                 dword ptr [esp + 0x28], edi
            //   48894550             | dec                 eax
            //   488d4c2440           | add                 esp, 0x20

        $sequence_3 = { 4d8be6 482bea 4d2be7 4d3bf7 7343 }
            // n = 5, score = 200
            //   4d8be6               | dec                 ebp
            //   482bea               | mov                 esp, esi
            //   4d2be7               | dec                 eax
            //   4d3bf7               | sub                 ebp, edx
            //   7343                 | dec                 ebp

        $sequence_4 = { 48c74424680f000000 c644245000 483bd9 0f82c0010000 482bd9 49c7c0ffffffff 493bd8 }
            // n = 7, score = 200
            //   48c74424680f000000     | xor    eax, esp
            //   c644245000           | dec                 eax
            //   483bd9               | mov                 dword ptr [esp + 0x430], eax
            //   0f82c0010000         | dec                 eax
            //   482bd9               | mov                 ebx, ecx
            //   49c7c0ffffffff       | dec                 ecx
            //   493bd8               | lea                 edi, [ebx + 0x10]

        $sequence_5 = { 4883c420 5f c3 488bca e8???????? 488bf8 4885c0 }
            // n = 7, score = 200
            //   4883c420             | dec                 eax
            //   5f                   | test                esi, esi
            //   c3                   | jne                 0xffffff8c
            //   488bca               | dec                 eax
            //   e8????????           |                     
            //   488bf8               | cmp                 dword ptr [esi + 0x38], 0
            //   4885c0               | dec                 eax

        $sequence_6 = { 488b36 4885f6 758a e9???????? 48837e3800 }
            // n = 5, score = 200
            //   488b36               | dec                 eax
            //   4885f6               | cmp                 dword ptr [edx], 0
            //   758a                 | jne                 0xa
            //   e9????????           |                     
            //   48837e3800           | dec                 eax

        $sequence_7 = { c3 48833a00 7508 488b4208 49894008 }
            // n = 5, score = 200
            //   c3                   | sub                 esp, edi
            //   48833a00             | dec                 ebp
            //   7508                 | cmp                 esi, edi
            //   488b4208             | jae                 0x45
            //   49894008             | ret                 

        $sequence_8 = { 03c1 68???????? 50 ffd3 83c40c 85c0 }
            // n = 6, score = 100
            //   03c1                 | add                 eax, ecx
            //   68????????           |                     
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax

        $sequence_9 = { 033d???????? 837d8400 0f4e3d???????? 83c734 }
            // n = 4, score = 100
            //   033d????????         |                     
            //   837d8400             | cmp                 dword ptr [ebp - 0x7c], 0
            //   0f4e3d????????       |                     
            //   83c734               | add                 edi, 0x34

        $sequence_10 = { 03c1 3bf8 0f42f8 33c9 8bc7 83c001 56 }
            // n = 7, score = 100
            //   03c1                 | add                 eax, ecx
            //   3bf8                 | cmp                 edi, eax
            //   0f42f8               | cmovb               edi, eax
            //   33c9                 | xor                 ecx, ecx
            //   8bc7                 | mov                 eax, edi
            //   83c001               | add                 eax, 1
            //   56                   | push                esi

        $sequence_11 = { 014e08 b801000000 5f 5e 5b 8b4c2458 }
            // n = 6, score = 100
            //   014e08               | add                 dword ptr [esi + 8], ecx
            //   b801000000           | mov                 eax, 1
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   8b4c2458             | mov                 ecx, dword ptr [esp + 0x58]

        $sequence_12 = { 03c1 50 898570ecffff 8d8574ecffff }
            // n = 4, score = 100
            //   03c1                 | add                 eax, ecx
            //   50                   | push                eax
            //   898570ecffff         | mov                 dword ptr [ebp - 0x1390], eax
            //   8d8574ecffff         | lea                 eax, [ebp - 0x138c]

        $sequence_13 = { 03c2 3bf8 0f838f010000 8b0d???????? }
            // n = 4, score = 100
            //   03c2                 | add                 eax, edx
            //   3bf8                 | cmp                 edi, eax
            //   0f838f010000         | jae                 0x195
            //   8b0d????????         |                     

        $sequence_14 = { 03c1 8b0d???????? a3???????? 3bc1 }
            // n = 4, score = 100
            //   03c1                 | add                 eax, ecx
            //   8b0d????????         |                     
            //   a3????????           |                     
            //   3bc1                 | cmp                 eax, ecx

        $sequence_15 = { 03421c 03c6 3bc8 760c }
            // n = 4, score = 100
            //   03421c               | add                 eax, dword ptr [edx + 0x1c]
            //   03c6                 | add                 eax, esi
            //   3bc8                 | cmp                 ecx, eax
            //   760c                 | jbe                 0xe

    condition:
        7 of them and filesize < 203776
}