rule win_moriagent_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.moriagent."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.moriagent"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c408 8b55c4 8b45f0 40 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8b55c4               | mov                 edx, dword ptr [ebp - 0x3c]
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   40                   | inc                 eax

        $sequence_1 = { 47 8b048500844200 885c012e 3bfa 7cea 8b7ddc }
            // n = 6, score = 100
            //   47                   | inc                 edi
            //   8b048500844200       | mov                 eax, dword ptr [eax*4 + 0x428400]
            //   885c012e             | mov                 byte ptr [ecx + eax + 0x2e], bl
            //   3bfa                 | cmp                 edi, edx
            //   7cea                 | jl                  0xffffffec
            //   8b7ddc               | mov                 edi, dword ptr [ebp - 0x24]

        $sequence_2 = { c785e4efffff00000000 c785e8efffff00000000 c785ecefffff00000000 83fa10 722f }
            // n = 5, score = 100
            //   c785e4efffff00000000     | mov    dword ptr [ebp - 0x101c], 0
            //   c785e8efffff00000000     | mov    dword ptr [ebp - 0x1018], 0
            //   c785ecefffff00000000     | mov    dword ptr [ebp - 0x1014], 0
            //   83fa10               | cmp                 edx, 0x10
            //   722f                 | jb                  0x31

        $sequence_3 = { 3bc1 7767 85ff 7425 41 8d0442 56 }
            // n = 7, score = 100
            //   3bc1                 | cmp                 eax, ecx
            //   7767                 | ja                  0x69
            //   85ff                 | test                edi, edi
            //   7425                 | je                  0x27
            //   41                   | inc                 ecx
            //   8d0442               | lea                 eax, [edx + eax*2]
            //   56                   | push                esi

        $sequence_4 = { eb4c 8b4714 8bd9 2bda 2bc2 3bd8 7727 }
            // n = 7, score = 100
            //   eb4c                 | jmp                 0x4e
            //   8b4714               | mov                 eax, dword ptr [edi + 0x14]
            //   8bd9                 | mov                 ebx, ecx
            //   2bda                 | sub                 ebx, edx
            //   2bc2                 | sub                 eax, edx
            //   3bd8                 | cmp                 ebx, eax
            //   7727                 | ja                  0x29

        $sequence_5 = { 8bc1 c785e4fdfffffc010000 0f43d6 c785f0fdffff07000000 c785f4fdffff01800000 2bd0 0f1f4000 }
            // n = 7, score = 100
            //   8bc1                 | mov                 eax, ecx
            //   c785e4fdfffffc010000     | mov    dword ptr [ebp - 0x21c], 0x1fc
            //   0f43d6               | cmovae              edx, esi
            //   c785f0fdffff07000000     | mov    dword ptr [ebp - 0x210], 7
            //   c785f4fdffff01800000     | mov    dword ptr [ebp - 0x20c], 0x8001
            //   2bd0                 | sub                 edx, eax
            //   0f1f4000             | nop                 dword ptr [eax]

        $sequence_6 = { 8d8dccefffff e8???????? 8d8dd4efffff e8???????? }
            // n = 4, score = 100
            //   8d8dccefffff         | lea                 ecx, [ebp - 0x1034]
            //   e8????????           |                     
            //   8d8dd4efffff         | lea                 ecx, [ebp - 0x102c]
            //   e8????????           |                     

        $sequence_7 = { 8b5d08 8b048500844200 56 57 8bfb 8b440818 }
            // n = 6, score = 100
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   8b048500844200       | mov                 eax, dword ptr [eax*4 + 0x428400]
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bfb                 | mov                 edi, ebx
            //   8b440818             | mov                 eax, dword ptr [eax + ecx + 0x18]

        $sequence_8 = { 83c408 85c0 742a f68568feffff10 7521 8b4704 8d4da8 }
            // n = 7, score = 100
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   742a                 | je                  0x2c
            //   f68568feffff10       | test                byte ptr [ebp - 0x198], 0x10
            //   7521                 | jne                 0x23
            //   8b4704               | mov                 eax, dword ptr [edi + 4]
            //   8d4da8               | lea                 ecx, [ebp - 0x58]

        $sequence_9 = { 7467 8b45e4 3bc8 7713 837de010 8bc7 894f10 }
            // n = 7, score = 100
            //   7467                 | je                  0x69
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   3bc8                 | cmp                 ecx, eax
            //   7713                 | ja                  0x15
            //   837de010             | cmp                 dword ptr [ebp - 0x20], 0x10
            //   8bc7                 | mov                 eax, edi
            //   894f10               | mov                 dword ptr [edi + 0x10], ecx

    condition:
        7 of them and filesize < 720896
}