rule win_moriya_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.moriya."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.moriya"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 4881c490000000 5b c3 4055 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   4881c490000000       | and                 dword ptr [esp + 0x38], 0
            //   5b                   | dec                 eax
            //   c3                   | and                 dword ptr [ebp - 9], 0
            //   4055                 | dec                 eax

        $sequence_1 = { 48833d????????00 7405 e8???????? 48833d????????00 7417 488d4dd0 ff15???????? }
            // n = 7, score = 200
            //   48833d????????00     |                     
            //   7405                 | mov                 edx, edi
            //   e8????????           |                     
            //   48833d????????00     |                     
            //   7417                 | dec                 eax
            //   488d4dd0             | mov                 dword ptr [ebx + 0x88], eax
            //   ff15????????         |                     

        $sequence_2 = { 488b9c2490000000 0f57c0 4d8bf0 488bea 0f1103 0f114310 48894320 }
            // n = 7, score = 200
            //   488b9c2490000000     | inc                 ebx
            //   0f57c0               | inc                 ecx
            //   4d8bf0               | inc                 ebp
            //   488bea               | dec                 eax
            //   0f1103               | mov                 dword ptr [esp + 0x98], ebx
            //   0f114310             | inc                 ecx
            //   48894320             | cmp                 ebp, 0x20

        $sequence_3 = { 66480f6ec2 0f16c0 0f1101 4c03c1 4883c110 4883e1f0 }
            // n = 6, score = 200
            //   66480f6ec2           | xor                 eax, eax
            //   0f16c0               | or                  ecx, eax
            //   0f1101               | sub                 ecx, 0xc350
            //   4c03c1               | cmp                 ecx, 0x64
            //   4883c110             | ja                  0x1f2a
            //   4883e1f0             | inc                 esp

        $sequence_4 = { 488945d8 488d442420 f30f7f45e4 c745e003500000 0f1005???????? }
            // n = 5, score = 200
            //   488945d8             | movups              xmmword ptr [ebp + ecx*4], xmm0
            //   488d442420           | inc                 ecx
            //   f30f7f45e4           | mov                 dword ptr [ebp + ecx*4 + 0x10], eax
            //   c745e003500000       | inc                 ecx
            //   0f1005????????       |                     

        $sequence_5 = { ff15???????? 488b0d???????? 488d842498000000 4889442430 33d2 48895c2428 }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   488b0d????????       |                     
            //   488d842498000000     | movzx               eax, word ptr [eax + edi + 2]
            //   4889442430           | movzx               ecx, al
            //   33d2                 | inc                 ecx
            //   48895c2428           | push                esp

        $sequence_6 = { 488364243800 498bd8 488364245000 488bfa 488bf1 33d2 }
            // n = 6, score = 200
            //   488364243800         | je                  0x1f3d
            //   498bd8               | dec                 eax
            //   488364245000         | mov                 edx, dword ptr [ebp + 0x6f]
            //   488bfa               | dec                 eax
            //   488bf1               | test                edx, edx
            //   33d2                 | je                  0x1f32

        $sequence_7 = { 4881c490000000 5b c3 4055 53 56 57 }
            // n = 7, score = 200
            //   4881c490000000       | sub                 esp, 0x60
            //   5b                   | dec                 eax
            //   c3                   | mov                 ebp, ecx
            //   4055                 | dec                 ecx
            //   53                   | mov                 ebx, ecx
            //   56                   | dec                 eax
            //   57                   | lea                 ecx, [0x707]

        $sequence_8 = { 4983f84f 7350 4d8bc8 4983e1f8 }
            // n = 4, score = 200
            //   4983f84f             | jne                 0x116e
            //   7350                 | dec                 eax
            //   4d8bc8               | arpl                word ptr [ecx + 0x3c], bp
            //   4983e1f8             | dec                 eax

        $sequence_9 = { 0f100d???????? 83a5a000000000 488d542460 488b0d???????? 4533c9 f30f7f45a0 }
            // n = 6, score = 200
            //   0f100d????????       |                     
            //   83a5a000000000       | mov                 dword ptr [esi + 0x20], eax
            //   488d542460           | mov                 ecx, dword ptr [edi + 0x10]
            //   488b0d????????       |                     
            //   4533c9               | mov                 dword ptr [esi + 4], ecx
            //   f30f7f45a0           | dec                 eax

    condition:
        7 of them and filesize < 99328
}