rule win_mortalkombat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mortalkombat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mortalkombat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d85e8feffff 50 68???????? e8???????? 85c0 0f849c020000 8d85e8feffff }
            // n = 7, score = 100
            //   8d85e8feffff         | lea                 eax, [ebp - 0x118]
            //   50                   | push                eax
            //   68????????           |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f849c020000         | je                  0x2a2
            //   8d85e8feffff         | lea                 eax, [ebp - 0x118]

        $sequence_1 = { c745e800000000 8d45d0 50 e8???????? c745b02c010000 c745ac69000000 }
            // n = 6, score = 100
            //   c745e800000000       | mov                 dword ptr [ebp - 0x18], 0
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   50                   | push                eax
            //   e8????????           |                     
            //   c745b02c010000       | mov                 dword ptr [ebp - 0x50], 0x12c
            //   c745ac69000000       | mov                 dword ptr [ebp - 0x54], 0x69

        $sequence_2 = { 7516 6a10 68???????? 68???????? ff7508 e8???????? }
            // n = 6, score = 100
            //   7516                 | jne                 0x18
            //   6a10                 | push                0x10
            //   68????????           |                     
            //   68????????           |                     
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     

        $sequence_3 = { 7401 41 8b35???????? 8bfe 33d2 83fa10 7502 }
            // n = 7, score = 100
            //   7401                 | je                  3
            //   41                   | inc                 ecx
            //   8b35????????         |                     
            //   8bfe                 | mov                 edi, esi
            //   33d2                 | xor                 edx, edx
            //   83fa10               | cmp                 edx, 0x10
            //   7502                 | jne                 4

        $sequence_4 = { 68???????? e8???????? 68???????? 6800020000 e8???????? }
            // n = 5, score = 100
            //   68????????           |                     
            //   e8????????           |                     
            //   68????????           |                     
            //   6800020000           | push                0x200
            //   e8????????           |                     

        $sequence_5 = { 33ce 033d???????? 33cf 03d1 81c3b979379e 8bca }
            // n = 6, score = 100
            //   33ce                 | xor                 ecx, esi
            //   033d????????         |                     
            //   33cf                 | xor                 ecx, edi
            //   03d1                 | add                 edx, ecx
            //   81c3b979379e         | add                 ebx, 0x9e3779b9
            //   8bca                 | mov                 ecx, edx

        $sequence_6 = { 6a00 e8???????? ff0d???????? 6801010000 }
            // n = 4, score = 100
            //   6a00                 | push                0
            //   e8????????           |                     
            //   ff0d????????         |                     
            //   6801010000           | push                0x101

        $sequence_7 = { 751e 68???????? 68???????? e8???????? 68???????? e8???????? c60000 }
            // n = 7, score = 100
            //   751e                 | jne                 0x20
            //   68????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   c60000               | mov                 byte ptr [eax], 0

        $sequence_8 = { 837d0c01 0f85a6010000 833d????????00 7506 ff0d???????? 68???????? 68???????? }
            // n = 7, score = 100
            //   837d0c01             | cmp                 dword ptr [ebp + 0xc], 1
            //   0f85a6010000         | jne                 0x1ac
            //   833d????????00       |                     
            //   7506                 | jne                 8
            //   ff0d????????         |                     
            //   68????????           |                     
            //   68????????           |                     

        $sequence_9 = { 0fb605???????? 83f801 7511 68???????? 68???????? }
            // n = 5, score = 100
            //   0fb605????????       |                     
            //   83f801               | cmp                 eax, 1
            //   7511                 | jne                 0x13
            //   68????????           |                     
            //   68????????           |                     

    condition:
        7 of them and filesize < 1224704
}