rule win_morto_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.morto."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.morto"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 e8???????? 59 8d8594fdffff 59 56 50 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8d8594fdffff         | lea                 eax, [ebp - 0x26c]
            //   59                   | pop                 ecx
            //   56                   | push                esi
            //   50                   | push                eax

        $sequence_1 = { 8bf9 760c 8a4d10 280c30 40 3b450c }
            // n = 6, score = 200
            //   8bf9                 | mov                 edi, ecx
            //   760c                 | jbe                 0xe
            //   8a4d10               | mov                 cl, byte ptr [ebp + 0x10]
            //   280c30               | sub                 byte ptr [eax + esi], cl
            //   40                   | inc                 eax
            //   3b450c               | cmp                 eax, dword ptr [ebp + 0xc]

        $sequence_2 = { 0f859f020000 53 57 8ac0 33db ba25537973 }
            // n = 6, score = 200
            //   0f859f020000         | jne                 0x2a5
            //   53                   | push                ebx
            //   57                   | push                edi
            //   8ac0                 | mov                 al, al
            //   33db                 | xor                 ebx, ebx
            //   ba25537973           | mov                 edx, 0x73795325

        $sequence_3 = { ff55ec 53 6a04 ff55e4 6a01 }
            // n = 5, score = 200
            //   ff55ec               | call                dword ptr [ebp - 0x14]
            //   53                   | push                ebx
            //   6a04                 | push                4
            //   ff55e4               | call                dword ptr [ebp - 0x1c]
            //   6a01                 | push                1

        $sequence_4 = { 6a01 68???????? ff35???????? a3???????? e8???????? 83c438 }
            // n = 6, score = 200
            //   6a01                 | push                1
            //   68????????           |                     
            //   ff35????????         |                     
            //   a3????????           |                     
            //   e8????????           |                     
            //   83c438               | add                 esp, 0x38

        $sequence_5 = { 3bc3 59 0f843e010000 8d4dbc 51 50 }
            // n = 6, score = 200
            //   3bc3                 | cmp                 eax, ebx
            //   59                   | pop                 ecx
            //   0f843e010000         | je                  0x144
            //   8d4dbc               | lea                 ecx, [ebp - 0x44]
            //   51                   | push                ecx
            //   50                   | push                eax

        $sequence_6 = { c20c00 b8???????? e8???????? 81ec38020000 53 56 57 }
            // n = 7, score = 200
            //   c20c00               | ret                 0xc
            //   b8????????           |                     
            //   e8????????           |                     
            //   81ec38020000         | sub                 esp, 0x238
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi

        $sequence_7 = { 50 6a00 ff15???????? 85c0 894704 742a 83c005 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   894704               | mov                 dword ptr [edi + 4], eax
            //   742a                 | je                  0x2c
            //   83c005               | add                 eax, 5

        $sequence_8 = { b9???????? e9???????? 55 8bec b86c260300 }
            // n = 5, score = 200
            //   b9????????           |                     
            //   e9????????           |                     
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   b86c260300           | mov                 eax, 0x3266c

        $sequence_9 = { 8b450c 68???????? c745f44d61696e c745f854687265 ff30 c745fc61640000 ff15???????? }
            // n = 7, score = 200
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   68????????           |                     
            //   c745f44d61696e       | mov                 dword ptr [ebp - 0xc], 0x6e69614d
            //   c745f854687265       | mov                 dword ptr [ebp - 8], 0x65726854
            //   ff30                 | push                dword ptr [eax]
            //   c745fc61640000       | mov                 dword ptr [ebp - 4], 0x6461
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 49152
}